package com.gogo.common.tools;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

import oth.syk.common.tools.StringUtil1;
import oth.syk.common.tools.Utils1;

public class StringUtil {

	/**
	 * 去除html的特殊符号 如：&nbsp; &gt;等
	 * @param str
	 * @return
	 */
	public static String replaceHTML(String str) {
		return StringUtil1.replaceHTML(str);
	}

	/**
	 * 去除各式各样的空白串
	 * 
	 * @param str
	 * @return
	 */
	public static String trimAll(String str) {
		return StringUtil1.trimAll(str);
	}

	/**
	 * 去除头尾的空白串加强
	 * 
	 * @param str
	 * @return
	 */
	public static String trim(String str) {
		return StringUtil1.trim(str);
	}

	/**
	 * 所有空格替换为标准空格
	 * 
	 * @param str
	 * @return
	 */
	public static String replaceNomalBlank(String str) {
		return StringUtil1.replaceNomalBlank(str);
	}

	/**
	 * 去除字符串的“-”和空串
	 * 
	 * @param str
	 * @return
	 */
	public static String replaceBlank2(String str) {
		return StringUtil1.replaceBlank2(str);
	}

	public static String randomString(int len) {
		return StringUtil1.randomString(len);
	}

	public static String StringLimit(String str, int limit) {
		return StringUtil1.StringLimit(str, limit);
	}
	
	public static Boolean isHttp(String str) {
		return StringUtil1.isHttp(str);
	}
	
	public static String beUrl(String host, String uri) {
		return StringUtil1.beUrl(host, uri);
	}
	
	/**
     * 将字符串text中由openToken和closeToken组成的占位符依次替换为args数组中的值
     * @param openToken
     * @param closeToken
     * @param text
     * @param args
     * @return
     */
    public static String parse(String openToken, String closeToken, String text, Object... args) {
        return StringUtil1.parse(openToken, closeToken, text, args);
    }

    public static String parse(String text, Object... args) {
        return StringUtil1.parse(text, args);
    }
    
    public static String parse(String text, Map<String, String> args) {
    	return StringUtil1.parse(text, args);
    }
    
    public static Map<String, Object> xmlStr2Map(String xmlStr) throws Exception {
    	return StringUtil1.xmlStr2Map(xmlStr);
    }
    
    public static Map<String, Object> doc2Map(Document doc){
    	 return StringUtil1.doc2Map(doc);
    }
    
    public static Map<String, Object> element2Map(Element e){
    	return StringUtil1.element2Map(e);
    }
    
    public static Map<String, Object> elements2Map(List<Element> es) {
    	return StringUtil1.elements2Map(es);
    }
    
    public static String map2XmlStr(Map<String, Object> map) {
    	return StringUtil1.map2XmlStr(map);
    }
    
	public static String map2XmlStr(String rootName, Map<String, Object> map) {
    	return StringUtil1.map2XmlStr(rootName, map);
    }
	
	public static String params2Json(String strs) {
		return StringUtil1.params2Json(strs);
	}
	
	public static String map2Params(Map<String, String> map) {
		return StringUtil1.map2Params(map);
	}
	
	public static <O> String Obj2Params(O o) throws Exception {
		return StringUtil1.Obj2Params(o);
	}
	
	public static String xmlStr2Json(String xmlStr) throws Exception {
		return StringUtil1.xmlStr2Json(xmlStr);
    }
	
	public static String getXmlStr(HttpServletRequest request) throws IOException {
		return StringUtil1.getXmlStr(request);
	}
    
	public static String bePath(String... strs) {
		return StringUtil1.bePath(strs);
	}
	
	public static String standardFirstToUpperEachWord(String sentence) {
		return StringUtil1.standardFirstToUpperEachWord(sentence);
	}
	
	public static String standardAllToUpper(String sentence) {
		return StringUtil1.standardAllToUpper(sentence);
	}
	
	public static String standardOnly(String sentence) {
		return StringUtil1.standardOnly(sentence);
	}
}
