package com.gogo.common.tools;

import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.DecodedJWT;

import oth.syk.common.tools.JwtUtils1;

import java.io.UnsupportedEncodingException;

/**
 * app登录token的生成和解析
 */
public class JwtUtils {
    /**
     * JWT生成Token.<br/>
     * <p>
     * JWT构成: header, payload, signature
     *
     * @throws UnsupportedEncodingException 
     * @throws JWTCreationException 
     * @throws IllegalArgumentException 
     */
    public static String createToken(Long point) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
    	return JwtUtils1.createToken(point);
    }
    
    public static String createToken(Long point, String[] authorities) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
        return JwtUtils1.createToken(point, authorities);
    }

    /**
     * 解密Token
     *
     * @param token
     * @return
     * @throws Exception
     */
    public static DecodedJWT verifyToken(String token) throws Exception {
        return JwtUtils1.verifyToken(token);
    }
    
    public static String getRealToken(String token) {
    	return JwtUtils1.getRealToken(token);
	}

    /**
     * 根据Token获取user_id
     *
     * @param token
     * @return user_id
     */
    public static Long getPoint(String token) throws Exception {
    	return JwtUtils1.getPoint(token);
    }
    
    public static String getPoint(DecodedJWT decodedJWT) throws Exception {
        return JwtUtils1.getPoint(decodedJWT);
    }
    
    public static String[] getAuthorities(DecodedJWT decodedJWT) throws Exception {
    	return JwtUtils1.getAuthorities(decodedJWT);
    }
    
    public static String getFoo(String token) throws Exception {
        return JwtUtils1.getFoo(token);
    }
    
    /**
     * token 刷新：
     * 1.小于TIME_OUT直接通过；
     * 2.大于TIME_OUT 小于FORBID_REFRES_HTIME需要刷新；
     * 3.超过FORBID_REFRES_HTIME 直接返回禁用刷新；
     *
     * @param oldToken
     * @return
     * @throws UnsupportedEncodingException 
     * @throws IllegalArgumentException 
     */
    public static String refresh(String oldToken) throws IllegalArgumentException, UnsupportedEncodingException {
        return JwtUtils1.refresh(oldToken);
    }
}
