package com.gogo.common.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.io.IOUtils;
import org.springframework.boot.system.ApplicationHome;

import oth.syk.common.tools.FileUtils1;

public class FileUtils {
	
	public static void saveFile(File file, String targetPathStr, String fileName, String suffix) throws IOException {
		FileUtils1.saveFile(file, targetPathStr, fileName, suffix);
    }
	
	public static void saveFile(byte[] content, String targetDir, String fileName, String suffix) throws IOException{
		FileUtils1.saveFile(content, targetDir, fileName, suffix);
	}
	
	public static void saveFile(byte[] content, String targetFile) throws IOException{
		FileUtils1.saveFile(content, targetFile);
	}
	
	public static void delete(String filePath) {
		FileUtils1.delete(filePath);
    }
	
	public static byte[] getBytes(String path) throws Exception {
		return FileUtils1.getBytes(path);
	}
	
	public static byte[] getBytes(File file) throws Exception {
		return FileUtils1.getBytes(file);
	}
	
	public static Set<String> txt2Set(InputStream txtStream) throws Exception{
		return FileUtils1.txt2Set(txtStream);
	}
	
	public static String getDir() {
		return FileUtils1.getDir();
	}
	
	public static String getJarHome() {
		return FileUtils1.getJarHome();
	}
	
	public static String getFileCharset(String path) throws IOException {
		return FileUtils1.getFileCharset(path);
	}
	
	public static Map<String, String> getMapFromTxt(String txtPath, String separator) throws IOException {
		return FileUtils1.getMapFromTxt(txtPath, separator);
	}
	
	public static Map<String, Set<String>> getMapGroupFromTxt(String txtPath, String separator) throws IOException {
		return FileUtils1.getMapGroupFromTxt(txtPath, separator);
	}
}
