package com.gogo.common.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

import oth.syk.common.tools.FTPUtils1;

public class FTPUtils {
	private FTPUtils1 nu;
	private FTPUtils() {}
	
	public static FTPUtils createFtpCli(String host, int port, String username, String password) {
    	FTPUtils ftp = new FTPUtils();
    	ftp.nu = FTPUtils1.createFtpCli(host, port, username, password, null);
        return ftp;
    }
	
    public static FTPUtils createFtpCli(String host, int port, String username, String password,String ftpBasePath) {
    	FTPUtils ftp = new FTPUtils();
    	ftp.nu = FTPUtils1.createFtpCli(host, port, username, password, ftpBasePath);
        return ftp;
    }
    
    public static FTPUtils createFtpCli(String host, int port, String username, String password, String charset,String ftpBasePath) {
    	FTPUtils ftp = new FTPUtils();
    	ftp.nu = FTPUtils1.createFtpCli(host, port, username, password, charset, ftpBasePath);
    	return ftp;
    }

    public void connect() throws IOException {
        nu.connect();
    }
    
    public static FTPClient connect(String host, int port, String username, String password, String basePath, String charset) throws IOException {
    	return FTPUtils1.connect(host, port, username, password, basePath, charset);
    }

    public boolean isConnected() {
        return nu.isConnected();
    }

    public String uploadFile(String fileName, InputStream inputStream, String uploadDir) throws IOException {
        return nu.uploadFile(fileName, inputStream, uploadDir);
    }

    public void downloadFileFromDailyDir(String ftpRealFilePath, OutputStream outputStream) throws IOException {
        nu.downloadFileFromDailyDir(ftpRealFilePath, outputStream);
    }

    public void retrieveFile(String ftpFileName, OutputStream out) throws IOException {
        nu.retrieveFile(ftpFileName, out);
    }

    public void deleteFile(String ftpFileName) throws IOException {
        nu.deleteFile(ftpFileName);
    }

    public void upload(String ftpFileName, File localFile) throws IOException {
        nu.upload(ftpFileName, localFile);
    }

    public void uploadDir(String remotePath, String localPath) throws IOException {
        nu.uploadDir(remotePath, localPath);
    }

    public void download(String ftpFileName, File localFile) throws IOException {
        nu.download(ftpFileName, localFile);
    }


    public boolean changeWorkingDirectory(String dir) {
        return nu.changeWorkingDirectory(dir);
    }

    public void downloadDir(String remotePath, String localPath) throws IOException {
        nu.downloadDir(remotePath, localPath);
    }


    public List<String> listFileNames(String filePath) throws IOException {
        return nu.listFileNames(filePath);
    }

    public void sendSiteCommand(String args) throws IOException {
        nu.sendSiteCommand(args);
    }

    public String printWorkingDirectory() {
        return nu.printWorkingDirectory();
    }

    public boolean changeToParentDirectory() {
    	return nu.changeToParentDirectory();
    }

    public String printParentDirectory() {
        return nu.printParentDirectory();
    }

    public boolean makeDirectory(String pathname) throws IOException {
        return nu.makeDirectory(pathname);
    }

    public void makeDirs(String pathname) throws IOException {
        nu.makeDirs(pathname);
    }

    public void disconnect() {
        nu.disconnect();
    }
}
