package com.gogo.common.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import oth.syk.common.tools.ExcelUtil1;
import oth.syk.common.tools.StringUtil1;

/**
 * 对easypoi 一些简单的封装操作类 
 * 官方文档：http://easypoi.mydoc.io/
 * @author lhp
 *
 */
public class ExcelUtil {
	/**
	 * 导出Excel(如果fileName为空则会生成一个流水号命名,文件格式为.xlsx)
	 * @param list 导出的集合数据
	 * @param title Excel标题名称
	 * @param sheetName excel页的名称
	 * @param pojoClass 对应的实体类Class
	 * @param fileName 文件名称
	 * @param response HTTP输出流
	 * @throws IOException 
	 */
	public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass,String fileName, HttpServletResponse response) throws IOException{
		ExcelUtil1.exportExcel(list, title, sheetName, pojoClass, fileName, response);
    }
	
	public static void fillTemplate2Live(String templatePath, String liveDir, String fileName, Map<String, Object> dataMap) throws IOException{
		ExcelUtil1.fillTemplate2Live(templatePath, liveDir, fileName, dataMap);
    }
}
