package com.gogo.common.mvc.mapper.provider;

import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

import java.util.Date;
import java.util.Set;

public class BatchWriteProvider extends MapperTemplate {

	public BatchWriteProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
		super(mapperClass, mapperHelper);
	}
	
	public String insertList(MappedStatement ms) {
		final Class<?> entityClass = getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.insertIntoTable(entityClass, tableName(entityClass)));
        sql.append(SqlHelper.insertColumns(entityClass, false, false, false));
        sql.append(" VALUES ");
        sql.append("<foreach collection=\"list\" item=\"record\" separator=\",\" >");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (column.isInsertable()) {
                sql.append(column.getColumnHolder("record") + ",");
            }
        }
        sql.append("</trim>");
        sql.append("</foreach>");
        return sql.toString();
	}
	
	public String insertListSelective(MappedStatement ms) {
		final Class<?> entityClass = getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        sql.append("<foreach collection=\"list\" item=\"record\" separator=\";\">");
        sql.append(SqlHelper.insertIntoTable(entityClass, tableName(entityClass)));
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (column.isInsertable()) {
            	sql.append(SqlHelper.getIfNotNull("record", column, column.getColumn()+",", true));
            }
        }
        sql.append("</trim>");
        sql.append("<trim prefix=\"VALUES (\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (column.isInsertable()) {
            	sql.append(SqlHelper.getIfNotNull("record", column, column.getColumnHolder("record")+",", true));
            }
        }
        sql.append("</trim>");
        sql.append("</foreach>");
        return sql.toString();
	}
	
	public String updateListByPrimaryKey(MappedStatement ms) {
		final Class<?> entityClass = getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append("<foreach  collection=\"list\" item=\"item\" index=\"index\" separator=\";\" >");
        sql.append(SqlHelper.updateTable(entityClass, tableName(entityClass)));
        sql.append("<set>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isId() && column.isUpdatable()) {
            	String columnEqualsHolder = column.getColumnEqualsHolder("item");
                sql.append(columnEqualsHolder).append(",");
            }
        }
        sql.append("</set>");
        sql.append("<where>");
        Set<EntityColumn> pkColumns = EntityHelper.getPKColumns(entityClass);
        if(pkColumns.size() == 0 || pkColumns.size() > 1) {
        	throw new IllegalArgumentException("主键不存在或有多个主键，不能使用批量修改！");
        }
        EntityColumn key = pkColumns.iterator().next();
        String primaryKey = key.getColumn();
        String field = key.getEntityField().getName();
        sql.append(primaryKey).append(" = #{item."+field+"}");
        sql.append("</where>");
        sql.append("</foreach>");
        return sql.toString();
	}
	
	public String updateListByPrimaryKeySelective(MappedStatement ms) {
		final Class<?> entityClass = getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append("<foreach  collection=\"list\" item=\"item\" index=\"index\" separator=\";\" >");
        sql.append(SqlHelper.updateTable(entityClass, tableName(entityClass)));
        sql.append("<set>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isId() && column.isUpdatable()) {
            	String equalsHolder = SqlHelper.getIfNotNull("item", column, column.getColumnEqualsHolder("item") +",", true);
                sql.append(equalsHolder);
            }
        }
        sql.append("</set>");
        sql.append("<where>");
        Set<EntityColumn> pkColumns = EntityHelper.getPKColumns(entityClass);
        if(pkColumns.size() == 0 || pkColumns.size() > 1) {
        	throw new IllegalArgumentException("主键不存在或有多个主键，不能使用批量修改！");
        }
        EntityColumn key = pkColumns.iterator().next();
        String primaryKey = key.getColumn();
        String field = key.getEntityField().getName();
        sql.append(primaryKey).append(" = #{item."+field+"}");
        sql.append("</where>");
        sql.append("</foreach>");
        return sql.toString();
	}
	
	public String selectByIds(MappedStatement ms) {
		final Class<?> entityClass = getEntityClass(ms);
		setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, tableName(entityClass)));
        sql.append("<where>");
        Set<EntityColumn> pkColumns = EntityHelper.getPKColumns(entityClass);
        if(pkColumns.size() == 0 || pkColumns.size() > 1) {
        	throw new IllegalArgumentException("主键不存在或有多个主键，不能使用批量查询！");
        }
        String primaryKey = pkColumns.iterator().next().getColumn();
        sql.append(primaryKey).append(" in ");
        sql.append("<foreach collection=\"list\" open=\"(\" close=\")\" item=\"item\" separator=\",\">");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        sql.append("#{item}");
        sql.append("</trim>");
        sql.append("</foreach>");
        sql.append("</where>");
        return sql.toString();
	}

    public String deleteByIds(MappedStatement ms) {
        final Class<?> entityClass = getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.deleteFromTable(entityClass, tableName(entityClass)));
        sql.append("<where>");
        Set<EntityColumn> pkColumns = EntityHelper.getPKColumns(entityClass);
        if(pkColumns.size() == 0 || pkColumns.size() > 1) {
        	throw new IllegalArgumentException("主键不存在或有多个主键，不能使用批量删除！");
        }
        String primaryKey = pkColumns.iterator().next().getColumn();
        sql.append(primaryKey).append(" in ");
        sql.append("<foreach collection=\"list\" open=\"(\" close=\")\" item=\"item\" separator=\",\">");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        sql.append("#{item}");
        sql.append("</trim>");
        sql.append("</foreach>");
        sql.append("</where>");
        return sql.toString();
    }
    
    public String selectBySelective(MappedStatement ms) {
    	final Class<?> entityClass = getEntityClass(ms);
		setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, tableName(entityClass)));
        sql.append("<trim prefix=\"WHERE\" prefixOverrides=\"AND\">");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
        	String equalsHolder = SqlHelper.getIfNotNull(column, " and " + column.getColumnEqualsHolder(), true);
            sql.append(equalsHolder);
        }
        sql.append("</trim>");
        return sql.toString();
    }
    
    public String selectBySelectiveLike(MappedStatement ms) {
    	final Class<?> entityClass = getEntityClass(ms);
		setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, tableName(entityClass)));
        sql.append("<trim prefix=\"WHERE\" prefixOverrides=\"AND\">");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
        	String content = " and " + column.getColumn() + "like CONCAT('%', " + column.getColumnHolder() + ", '%') ";
        	if(Date.class.equals(column.getJavaType())) {
        		content = " and " + column.getColumnEqualsHolder();
        	}
        	String equalsHolder = SqlHelper.getIfNotNull(column, content, true);
            sql.append(equalsHolder);
        }
        sql.append("</trim>");
        return sql.toString();
    }
}
