package com.gogo.common.mvc.mapper;

import org.apache.ibatis.annotations.*;

import com.gogo.common.mvc.mapper.provider.BatchWriteProvider;

import tk.mybatis.mapper.annotation.RegisterMapper;

import java.util.List;

@RegisterMapper
public interface BatchWriteMapper<T> {

	@Options(useGeneratedKeys = true, keyProperty = "id")
	@InsertProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
    int insertList(List<T> recordList);
	
	@Options(useGeneratedKeys = true, keyProperty = "id")
	@InsertProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
    int insertListSelective(List<T> recordList);
	
	@UpdateProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	int updateListByPrimaryKey(List<T> recordList);
	
	@UpdateProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	int updateListByPrimaryKeySelective(List<T> recordList);
	
	@SelectProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	List<T> selectByIds(List<Long> ids);

	@DeleteProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	int deleteByIds(List<Long> idList);
	
	@SelectProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	List<T> selectBySelective(T record);
	
	@SelectProvider(type = BatchWriteProvider.class, method = "dynamicSQL")
	List<T> selectBySelectiveLike(T record);
}
