package com.gogo.common.mvc.controller;

import com.auth0.jwt.exceptions.JWTCreationException;
import com.gogo.common.constants.CommonConstant;
import com.gogo.common.tools.ConfigUtils;
import com.gogo.common.tools.JwtUtils;

import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;

public class BaseController {
	protected final String REDIRECT = "redirect:";
	protected static final Integer pageSize = 10;
	
	
	protected void setUserInfo(HttpSession session, Object user, long userId, String username) {
		if(session == null){
			throw new RuntimeException("The parameter \"session\" that must be available!");
		}
		session.setAttribute(CommonConstant.USER, user);
		session.setAttribute(CommonConstant.USERID, userId);
		session.setAttribute(CommonConstant.USERNAME, username);
	}
	
	protected Object getUser(HttpServletRequest request) {
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		return getUser(request.getSession());
	}
	
	protected Object getUser(HttpSession session) {
		if(session == null){
			throw new RuntimeException("The parameter \"session\" that must be available!");
		}
		Object attribute = session.getAttribute(CommonConstant.USER);
		return attribute;
	}
	
	protected void removeUserInfo(HttpSession session) {
		if(session == null){
			throw new RuntimeException("The parameter \"session\" that must be available!");
		}
		session.removeAttribute(CommonConstant.USER);
		session.removeAttribute(CommonConstant.USERID);
		session.removeAttribute(CommonConstant.USERNAME);
	}
	
	protected String getToken(HttpServletRequest request) {
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		String headerName = ConfigUtils.getPropertyValue("authorization.header.name");
    	String headerStart = ConfigUtils.getPropertyValue("authorization.header.start");
    	String authHeader = request.getHeader(headerName);
    	
    	if(StringUtils.isBlank(authHeader) || !authHeader.startsWith(headerStart)) {
    		throw new IllegalArgumentException("获取token失败！");
    	}
    	String authToken = authHeader.substring(headerStart.length()); // The part after "Bearer "
    	return authToken;
		
	}
	
	protected String getUserName(HttpServletRequest request){
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		return getUserName(request.getSession());
	}
	
	protected Long getUserId(HttpServletRequest request){
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		return getUserId(request.getSession());
	}
	
	protected long getUserIdByToken(HttpServletRequest request) throws Exception {
		String token = this.getToken(request);
		long point = JwtUtils.getPoint(token);
		return point;
	}
	
	protected String putToken(HttpServletResponse response, Long userId) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
		String headerName = ConfigUtils.getPropertyValue("authorization.header.name");
    	String headerStart = ConfigUtils.getPropertyValue("authorization.header.start");
    	String token = JwtUtils.createToken(userId);
    	response.addHeader(headerName, headerStart + token);
    	response.addHeader("Access-Control-Expose-Headers", headerName);
    	return token;
	}
	
	protected String putToken(HttpServletResponse response, Long userId, String[] authorities) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
		String headerName = ConfigUtils.getPropertyValue("authorization.header.name");
    	String headerStart = ConfigUtils.getPropertyValue("authorization.header.start");
    	String token = JwtUtils.createToken(userId, authorities);
    	response.addHeader(headerName, headerStart + token);
    	response.addHeader("Access-Control-Expose-Headers", headerName);
    	return token;
	}
	
	protected String getUserName(HttpSession session){
		if(session == null){
			throw new RuntimeException("The parameter \"session\" that must be available!");
		}
		Object attribute = session.getAttribute(CommonConstant.USERNAME);
		if(attribute != null){
			return attribute.toString();
		}
		return null;
	}
	
	protected Long getUserId(HttpSession session){
		if(session == null){
			throw new RuntimeException("The parameter \"session\" that must be available!");
		}
		Object attribute = session.getAttribute(CommonConstant.USERID);
		if(attribute != null){
			return Long.valueOf(attribute.toString());
		}
		return null;
	}
	
	protected String getHost(HttpServletRequest request){
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		String serverPortStr = "";
		int serverPort = request.getServerPort();
		if(serverPort != 80 && serverPort != 443) {
			serverPortStr = ":"+serverPort;
		}
		String scheme = request.getScheme();
		String serverName = request.getServerName();
		String contextPath = request.getContextPath();
		
		StringBuffer sb = new StringBuffer();
		sb.append(scheme).append("://").append(serverName).append(serverPortStr).append(contextPath);
		return sb.toString();
	}
	
	protected String getUserAgent(HttpServletRequest request) {
		if(request == null){
			throw new RuntimeException("The parameter \"request\" that must be available!");
		}
		
		return request.getHeader("User-Agent");
	}
}
