package com.gogo.common.mvc.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.gogo.common.mvc.configuration.properties.SwaggerEnableProperties;
import com.google.common.base.Predicates;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class Swagger2Configuration {
	@Autowired
	private SwaggerEnableProperties swaggerEnableConfig;
	@Bean
	public Docket webApi() {
		return new Docket(DocumentationType.SWAGGER_2)
				.enable(swaggerEnableConfig.isEnabled())
//		        .groupName("swagger.json")
		        .apiInfo(apiInfo())
				.select()
				.apis(RequestHandlerSelectors.basePackage("com.gogo"))
				.paths(PathSelectors.any())
//				.apis(RequestHandlerSelectors.any())
				.build();
	}

	private ApiInfo apiInfo() {
		return new ApiInfoBuilder()
				.title("Mapin7")
				.termsOfServiceUrl("")
				.version("1.0").build();
	}

}