package com.gogo.common.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

import com.gogo.common.http.callback.HttpSendCallback;
import com.gogo.common.ui.MultiFile;

import oth.syk.common.http.HttpUtils1;

public class HttpUtils {
	public static <T> HttpResult<T> httpGet(String url, Map<String, String> params, HttpSendCallback<T> callback) throws UnsupportedEncodingException {
		return HttpUtils1.httpGet(url, params, callback);
	}
	
	public static String httpGet(String url, Map<String, String> params) throws Exception {
		return HttpUtils1.httpGet(url, params);
	}
	
	
	public static String httpGet(String url) throws Exception {
		return HttpUtils1.httpGet(url);
	}
	
	public static <T, PARAMS> HttpResult<T> jsonPost(String url, PARAMS params, HttpSendCallback<T> callback) {
		return HttpUtils1.jsonPost(url, params, callback);
	}
	
	public static <PARAMS> String jsonPost(String url, PARAMS params) throws Exception {
		return HttpUtils1.jsonPost(url, params);
	}
	
	public static String jsonPost(String url) throws Exception {
		return HttpUtils1.jsonPost(url);
	}

	public static <T> HttpResult<T> httpPost(String url, Map<String, String> params, HttpSendCallback<T> callback) throws IOException {
		return HttpUtils1.httpPost(url, params, callback);
	}
	
	public static String httpPost(String url, Map<String, String> params) throws Exception {
		return HttpUtils1.httpPost(url, params);
	}
	
	public static String httpPost(String url) throws Exception {
		return HttpUtils1.httpPost(url);
	}
	
	public static String origGet(String url, Map<String, String> params) throws Exception {
		return HttpUtils1.origGet(url, params);
	}
	
	/**
	 * 将网络文件转换为byte[]
	 * @param url
	 * @return
	 * @throws Exception
	 */
	public static byte[] getBytes(String url) throws Exception {
		return HttpUtils1.getBytes(url);
	}
	
	public static <T> HttpResult<T> httpUpload(String url, List<MultiFile> files, Map<String, String> params, HttpSendCallback<T> callback) {
		return HttpUtils1.httpUpload(url, files, params, callback);
	}
	
}
