package com.gogo.common.enums;

import com.gogo.common.tools.StringUtil;

public enum OrderEnum {
	ASC(1, "ASC"),
	DESC(2, "DESC");
	
	private Integer code;
	private String desc;

	OrderEnum(Integer code, String desc){
		this.code = code;
		this.desc = desc;
	}
	
	public static Integer getCodeByName(String name){
		name = StringUtil.replaceBlank2(name).toUpperCase();
		OrderEnum[] values = OrderEnum.values();
		for(OrderEnum value : values){
			if(value.name().equals(name)){
				return value.getCode();
			}
		}
		return null;
	}
	
	public static Integer getCodeByDesc(String desc){
		OrderEnum[] values = OrderEnum.values();
		for(OrderEnum value : values){
			if(value.getDesc().equals(desc)){
				return value.getCode();
			}
		}
		return null;
	}
	
	public static String getDescByCode(Integer code){
		OrderEnum[] values = OrderEnum.values();
		for(OrderEnum value : values){
			if(value.getCode().equals(code)){
				return value.getDesc();
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
