package com.gogo.common.enums;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public enum  DayTimeEnum {

    NO1(5, 30, 0);
    private int hour;
    private int minute;
    private int second;

    DayTimeEnum(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }
    
    
    
    public static Date getTime(DayTimeEnum dt) throws ParseException {
    	int hour2 = dt.getHour();
    	int minute2 = dt.getMinute();
    	int second2 = dt.getSecond();
    	SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    	return sdf.parse(hour2 + ":" + minute2	+ ":" + second2);
    }
    
    public static String getTimeStr(DayTimeEnum dt) {
    	int hour2 = dt.getHour();
    	int minute2 = dt.getMinute();
    	int second2 = dt.getSecond();
    	return hour2 + ":" + minute2	+ ":" + second2;
    }

	public int getHour() {
		return hour;
	}

	public void setHour(int hour) {
		this.hour = hour;
	}

	public int getMinute() {
		return minute;
	}

	public void setMinute(int minute) {
		this.minute = minute;
	}

	public int getSecond() {
		return second;
	}

	public void setSecond(int second) {
		this.second = second;
	}
}
