package com.gogo.common.enums;

import org.apache.commons.lang3.StringUtils;

import com.gogo.common.ui.DBInfo;

public enum  DBTypeEnum {

    SQLSERVER("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://${ip}:${port};DatabaseName=${dbName}"),
	ACCESS_REMOTE("access_remote", "org.objectweb.rmijdbc.Driver", "jdbc:rmi://${ip}/jdbc:odbc:${dbName}"),
	ACCESS("access", "net.ucanaccess.jdbc.UcanaccessDriver", "jdbc:ucanaccess:///${dbName}"),
	MYSQL("mysql", "", "");
    private String code;
    private String driverClass;
    private String url;

    DBTypeEnum(String code, String driverClass, String url) {
        this.code = code;
        this.driverClass = driverClass;
        this.url = url;
    }
    
    public void check(String dbIp, String dbPort, String dbName, String dbUsername, String dbPassword) {
    	if(this.getCode().equals(DBTypeEnum.ACCESS_REMOTE.getCode())) {
			if(StringUtils.isBlank(dbIp) || StringUtils.isBlank(dbName)) {
				throw new IllegalArgumentException("请检查数据库配置信息: db.ip, db.name");
			}
		}else if(this.getCode().equals(DBTypeEnum.SQLSERVER.getCode())) {
			if(StringUtils.isBlank(dbIp) || StringUtils.isBlank(dbPort) || 
					StringUtils.isBlank(dbName) || StringUtils.isBlank(dbUsername) || 
					StringUtils.isBlank(dbPassword)) {
				throw new IllegalArgumentException("请检查数据库配置信息: db.ip, db.port, db.name, db.username, dbPassword");
			}
		}else if(this.getCode().equals(DBTypeEnum.ACCESS.getCode())) {
			if(dbName.indexOf("/") ==  -1 && dbName.indexOf("\\") == -1) {
				throw new IllegalArgumentException("访问本地Access数据库时，dbName必须是全路径。");
			}
		}
    }
    
    public String getUrl(String ip, String port, String dbName) {
    	String url = this.getUrl();
    	if(StringUtils.isNotBlank(ip)) {
    		url = url.replace("${ip}", ip);
    	}
    	if(StringUtils.isNotBlank(port)) {
    		url = url.replace("${port}", port);
    	}
    	if(StringUtils.isNotBlank(dbName)) {
    		url = url.replace("${dbName}", dbName);
    	}
		return url;
    }

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getDriverClass() {
		return driverClass;
	}

	public void setDriverClass(String driverClass) {
		this.driverClass = driverClass;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
