/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.web.common;

import cn.com.ry.framework.linklog.web.interceptor.LinkLogSpringMvcInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;

public class SpringMvcPluginCommon {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcPluginCommon.class);

    public static void setSpringMvcPlugin(AbstractApplicationContext applicationContext) {
        if (applicationContext != null) {
            SpringMvcPluginCommon.createLinkLogSpringMvcInterceptor(applicationContext);
        }
    }

    public static void createLinkLogSpringMvcInterceptor(AbstractApplicationContext applicationContext) {
        try {
            applicationContext.getBean("linkLogSpringMvcConfigurer");
        }
        catch (Exception e) {
            try {
                BeanDefinitionBuilder mappedInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.web.servlet.handler.MappedInterceptor");
                mappedInterceptorBuilder.addConstructorArgValue((Object)"/**");
                mappedInterceptorBuilder.addConstructorArgValue((Object)new LinkLogSpringMvcInterceptor());
                DefaultListableBeanFactory mappedInterceptorBeanFacotry = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
                mappedInterceptorBeanFacotry.registerBeanDefinition("linkLogSpringMvcConfigurer", (BeanDefinition)mappedInterceptorBuilder.getBeanDefinition());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

