/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtil {
    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ReflectUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if ((types1 == null || types1.equals("")) && (types2 == null || types2.equals(""))) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ReflectUtil.isBasicType(type1) && ReflectUtil.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class ... paramTypes) throws SecurityException {
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null && methods.length > 0 && methodName != null && !methodName.equals("")) {
            for (Method method : methods) {
                String a_methodName = method.getName();
                if (!a_methodName.equals(methodName) || !ReflectUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static enum BasicType {
        BYTE,
        SHORT,
        INT,
        INTEGER,
        LONG,
        DOUBLE,
        FLOAT,
        BOOLEAN,
        CHAR,
        CHARACTER,
        STRING;

        public static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;
        public static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP;

        public static Class<?> wrap(Class<?> clazz) {
            if (null == clazz || !clazz.isPrimitive()) {
                return clazz;
            }
            Class<?> result = PRIMITIVE_WRAPPER_MAP.get(clazz);
            return null == result ? clazz : result;
        }

        public static Class<?> unWrap(Class<?> clazz) {
            if (null == clazz || clazz.isPrimitive()) {
                return clazz;
            }
            Class<?> result = WRAPPER_PRIMITIVE_MAP.get(clazz);
            return null == result ? clazz : result;
        }

        static {
            WRAPPER_PRIMITIVE_MAP = new ConcurrentHashMap(8);
            PRIMITIVE_WRAPPER_MAP = new ConcurrentHashMap(8);
            WRAPPER_PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Character.class, Character.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Double.class, Double.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Float.class, Float.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Long.class, Long.TYPE);
            WRAPPER_PRIMITIVE_MAP.put(Short.class, Short.TYPE);
            for (Map.Entry<Class<?>, Class<?>> entry : WRAPPER_PRIMITIVE_MAP.entrySet()) {
                PRIMITIVE_WRAPPER_MAP.put(entry.getValue(), entry.getKey());
            }
        }
    }
}

