/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.resttemplate.filter;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.util.HostInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LinkLogRestTemplateFilter
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogRestTemplateFilter.class);

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        String traceId = LinkLogContext.getTraceId();
        if (traceId != null && !traceId.equals("")) {
            httpRequest.getHeaders().set("linkLogTraceid", traceId);
            httpRequest.getHeaders().set("linkLogSpanid", SpanIdGenerator.generateNextSpanId());
            httpRequest.getHeaders().set("linkLogPreApp", HostInfo.getAppName());
            httpRequest.getHeaders().set("linkLogPreHost", HostInfo.getHostName());
            httpRequest.getHeaders().set("linkLogPreIp", HostInfo.getIp());
        } else {
            logger.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return clientHttpRequestExecution.execute(httpRequest, body);
    }
}

