/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.okhttp.filter;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.util.HostInfo;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkLogOkHttpInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogOkHttpInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request requestFu = null;
        try {
            requestFu = chain.request();
            String url = requestFu.url().toString();
            if (url != null && !url.trim().equalsIgnoreCase("")) {
                String traceId = LinkLogContext.getTraceId();
                if (traceId != null && !traceId.equals("")) {
                    Request.Builder builder = requestFu.newBuilder();
                    Request build = builder.url(url).build();
                    String preApp = HostInfo.getAppName();
                    String preHost = HostInfo.getHostName();
                    String preIp = HostInfo.getIp();
                    String spanId = SpanIdGenerator.generateNextSpanId();
                    builder.addHeader("linkLogPreApp", preApp);
                    builder.addHeader("linkLogPreHost", preHost);
                    builder.addHeader("linkLogPreIp", preIp);
                    builder.addHeader("linkLogTraceid", traceId);
                    builder.addHeader("linkLogSpanid", spanId);
                    return chain.proceed(build);
                }
                logger.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (requestFu != null) {
            return chain.proceed(requestFu);
        }
        return null;
    }
}

