/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.logging.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4j2LinkLogSystem {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2LinkLogSystem.class);
    public static String OFF = "OFF";
    public static String FATAL = "FATAL";
    public static String ERROR = "ERROR";
    public static String WARN = "WARN";
    public static String INFO = "INFO";
    public static String DEBUG = "DEBUG";
    public static String TRACE = "TRACE";
    public static String ALL = "ALL";
    public static String ROOT = "ROOT";

    public static void setLevel(String loggerName, String level) {
        try {
            if (loggerName == null || loggerName.trim().equals("") || ROOT.equalsIgnoreCase(loggerName)) {
                loggerName = "";
            }
            LoggerConfig loggerConfig = (LoggerConfig)LoggerContext.getContext((boolean)false).getConfiguration().getLoggers().get(loggerName);
            Level log4jLevel = Log4j2LinkLogSystem.convertLogLevel(level);
            if (log4jLevel != null) {
                loggerConfig.setLevel(log4jLevel);
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u7ea7\u522b\u4fee\u6539\u9519\u8bef");
        }
    }

    public static Level convertLogLevel(String level) {
        if (level != null && !level.equals("")) {
            if (level.equalsIgnoreCase(ALL)) {
                return Level.ALL;
            }
            if (level.equalsIgnoreCase(TRACE)) {
                return Level.TRACE;
            }
            if (level.equalsIgnoreCase(DEBUG)) {
                return Level.DEBUG;
            }
            if (level.equalsIgnoreCase(INFO)) {
                return Level.INFO;
            }
            if (level.equalsIgnoreCase(DEBUG)) {
                return Level.DEBUG;
            }
            if (level.equalsIgnoreCase(WARN)) {
                return Level.WARN;
            }
            if (level.equalsIgnoreCase(ERROR)) {
                return Level.ERROR;
            }
            if (level.equalsIgnoreCase(FATAL)) {
                return Level.FATAL;
            }
            if (level.equalsIgnoreCase(OFF)) {
                return Level.OFF;
            }
        }
        return null;
    }
}

