/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.httpclient.filter;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.util.HostInfo;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkLogHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogHttpRequestInterceptor.class);

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        String traceId = LinkLogContext.getTraceId();
        if (traceId != null && !traceId.equals("")) {
            String preApp = HostInfo.getAppName();
            String preHost = HostInfo.getHostName();
            String preIp = HostInfo.getIp();
            String spanId = SpanIdGenerator.generateNextSpanId();
            httpRequest.addHeader("linkLogPreApp", preApp);
            httpRequest.addHeader("linkLogPreHost", preHost);
            httpRequest.addHeader("linkLogPreIp", preIp);
            httpRequest.addHeader("linkLogTraceid", traceId);
            httpRequest.addHeader("linkLogSpanid", spanId);
        } else {
            logger.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

