/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.gateway.common;

import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.core.LinkLogHandler;
import cn.com.ry.framework.linklog.core.LinkLogLabel;
import cn.com.ry.framework.linklog.util.HostInfo;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class LinkLogGatewayCommon
extends LinkLogHandler {
    private static final Logger log = LoggerFactory.getLogger(LinkLogGatewayCommon.class);
    private static volatile LinkLogGatewayCommon linkLogGatewayCommon;
    private static final Integer FIRST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkLogGatewayCommon loadInstance() {
        if (linkLogGatewayCommon != null) return linkLogGatewayCommon;
        Class<LinkLogGatewayCommon> clazz = LinkLogGatewayCommon.class;
        synchronized (LinkLogGatewayCommon.class) {
            if (linkLogGatewayCommon != null) return linkLogGatewayCommon;
            linkLogGatewayCommon = new LinkLogGatewayCommon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return linkLogGatewayCommon;
        }
    }

    public ServerWebExchange preHandle(ServerWebExchange exchange) {
        List preIps;
        List preHosts;
        List preApps;
        List spanIds;
        String traceId = null;
        String spanId = null;
        String preApp = null;
        String preHost = null;
        String preIp = null;
        HttpHeaders headers = exchange.getRequest().getHeaders();
        List traceIds = headers.get((Object)"linkLogTraceid");
        if (traceIds != null && traceIds.size() > 0) {
            traceId = (String)traceIds.get(FIRST);
        }
        if ((spanIds = headers.get((Object)"linkLogSpanid")) != null && spanIds.size() > 0) {
            spanId = (String)spanIds.get(FIRST);
        }
        if ((preApps = headers.get((Object)"linkLogPreApp")) != null && preApps.size() > 0) {
            preApp = (String)preApps.get(FIRST);
        }
        if ((preHosts = headers.get((Object)"linkLogPreHost")) != null && preHosts.size() > 0) {
            preHost = (String)preHosts.get(FIRST);
        }
        if ((preIps = headers.get((Object)"linkLogPreIp")) != null && preIps.size() > 0) {
            preIp = (String)preIps.get(FIRST);
        }
        LinkLogLabel labelBean = new LinkLogLabel(preApp, preHost, preIp, traceId, spanId);
        this.processProviderSide(labelBean);
        String tmp_traceId = labelBean.getTraceId();
        if (tmp_traceId != null && !tmp_traceId.equals("")) {
            Consumer<HttpHeaders> httpHeaders = httpHeader -> {
                httpHeader.set("linkLogTraceid", tmp_traceId);
                httpHeader.set("linkLogSpanid", SpanIdGenerator.generateNextSpanId());
                httpHeader.set("linkLogPreApp", HostInfo.getAppName());
                httpHeader.set("linkLogPreHost", HostInfo.getHostName());
                httpHeader.set("linkLogPreIp", HostInfo.getIp());
            };
            ServerHttpRequest serverHttpRequest = exchange.getRequest().mutate().headers(httpHeaders).build();
            return exchange.mutate().request(serverHttpRequest).build();
        }
        log.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        return exchange;
    }

    static {
        FIRST = 0;
    }
}

