/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.fegin.filter;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.util.HostInfo;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkLogFeignFilter
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogFeignFilter.class);

    public void apply(RequestTemplate requestTemplate) {
        String traceId = LinkLogContext.getTraceId();
        if (traceId != null && !traceId.equals("")) {
            requestTemplate.header("linkLogTraceid", new String[]{traceId});
            requestTemplate.header("linkLogSpanid", new String[]{SpanIdGenerator.generateNextSpanId()});
            requestTemplate.header("linkLogPreApp", new String[]{HostInfo.getAppName()});
            requestTemplate.header("linkLogPreHost", new String[]{HostInfo.getHostName()});
            requestTemplate.header("linkLogPreIp", new String[]{HostInfo.getIp()});
        } else {
            logger.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

