/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.dubbo.filter;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.core.LinkLogHandler;
import cn.com.ry.framework.linklog.core.LinkLogLabel;
import cn.com.ry.framework.linklog.util.HostInfo;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=-10000)
public class LinkLogDubboxFilter
extends LinkLogHandler
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LinkLogDubboxFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        String side = invoker.getUrl().getParameter("side");
        if (side.equals("provider")) {
            Result result2;
            String preApp = invocation.getAttachment("linkLogPreApp");
            String preHost = invocation.getAttachment("linkLogPreHost");
            String preIp = invocation.getAttachment("linkLogPreIp");
            String traceId = invocation.getAttachment("linkLogTraceid");
            String spanId = invocation.getAttachment("linkLogSpanid");
            LinkLogLabel labelBean = new LinkLogLabel(preApp, preHost, preIp, traceId, spanId);
            this.processProviderSide(labelBean);
            try {
                result2 = invoker.invoke(invocation);
            }
            finally {
                this.cleanThreadLocal();
            }
            return result2;
        }
        if (side.equals("consumer")) {
            String traceId = LinkLogContext.getTraceId();
            if (traceId != null && !traceId.equals("")) {
                String appName = HostInfo.getAppName();
                String ip = HostInfo.getIp();
                String hostName = HostInfo.getHostName();
                RpcContext.getContext().setAttachment("linkLogTraceid", traceId);
                RpcContext.getContext().setAttachment("linkLogPreApp", appName);
                RpcContext.getContext().setAttachment("linkLogPreHost", hostName);
                RpcContext.getContext().setAttachment("linkLogPreIp", ip);
                RpcContext.getContext().setAttachment("linkLogSpanid", SpanIdGenerator.generateNextSpanId());
            } else {
                log.debug("[LinkLog]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
            }
            result = invoker.invoke(invocation);
        } else {
            result = null;
        }
        return result;
    }
}

