/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.core;

import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.LinkLogLabelGenerator;
import cn.com.ry.framework.linklog.core.LinkLogLabel;
import cn.com.ry.framework.linklog.id.LinkLogIdGeneratorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LinkLogHandler {
    protected static final Logger log = LoggerFactory.getLogger(LinkLogHandler.class);

    public void processProviderSide(LinkLogLabel labelBean) {
        if (labelBean.getPreApp() == null || labelBean.getPreApp().equals("")) {
            labelBean.setPreApp("NONE");
        }
        LinkLogContext.putPreApp(labelBean.getPreApp());
        if (labelBean.getPreHost() == null || labelBean.getPreHost().equals("")) {
            labelBean.setPreHost("NONE");
        }
        LinkLogContext.putPreHost(labelBean.getPreHost());
        if (labelBean.getPreIp() == null || labelBean.getPreIp().equals("")) {
            labelBean.setPreIp("NONE");
        }
        LinkLogContext.putPreIp(labelBean.getPreIp());
        if (labelBean.getTraceId() == null || labelBean.getTraceId().equals("")) {
            labelBean.setTraceId(LinkLogIdGeneratorLoader.getIdGenerator().generateTraceId());
        }
        LinkLogContext.putSpanId(labelBean.getSpanId());
        LinkLogContext.putTraceId(labelBean.getTraceId());
        String linkLogLabel = LinkLogLabelGenerator.generateLinkLogLabel(labelBean.getPreApp(), labelBean.getPreHost(), labelBean.getPreIp(), labelBean.getTraceId(), LinkLogContext.getSpanId());
        if (LinkLogContext.hasLinkLogMDC()) {
            MDC.put((String)"linkLog", (String)linkLogLabel);
        }
    }

    public void cleanThreadLocal() {
        LinkLogContext.removePreApp();
        LinkLogContext.removePreHost();
        LinkLogContext.removePreIp();
        LinkLogContext.removeTraceId();
        LinkLogContext.removeSpanId();
        if (LinkLogContext.hasLinkLogMDC()) {
            MDC.remove((String)"linkLog");
        }
    }
}

