/*
 * Decompiled with CFR 0.152.
 */
package cn.com.ry.framework.linklog.configcenter.disconf;

import cn.com.ry.framework.linklog.configcenter.disconf.ILinkLogDisconf;
import cn.com.ry.framework.linklog.logging.LinkLogSystem;
import com.baidu.disconf.client.common.annotations.DisconfUpdateService;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisconfUpdateService(confFileKeys={"linklog.properties"})
public class LinkLogDisconf
implements IDisconfUpdate,
ILinkLogDisconf {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogDisconf.class);
    private static volatile Properties configProps = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDisconf() {
        InputStream inputStream = null;
        try {
            DisconfStoreProcessor disconfStoreProcessor = DisconfStoreProcessorFactory.getDisconfStoreFileProcessor();
            Set fileSets = disconfStoreProcessor.getConfKeySet();
            if (fileSets != null && fileSets.size() > 0) {
                for (String fileSet : fileSets) {
                    if (fileSet == null || !fileSet.endsWith(".properties")) continue;
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileSet);
                    configProps.load(inputStream);
                    for (Map.Entry<Object, Object> entry : configProps.entrySet()) {
                        this.onDisconfItemChanged(fileSet, entry.getKey().toString(), entry.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Disconf\u914d\u7f6e\u6587\u4ef6, \u521d\u6b21\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void onDisconfItemChanged(String file, String key, Object value) {
        logger.info("Disconf\u914d\u7f6e\u6587\u4ef6\u9879\u76ee\u53d8\u66f4, file={}, key={}, value={}", new Object[]{file, key, value});
        try {
            if (value != null) {
                LinkLogSystem.setLevel(key, value.toString());
            }
        }
        catch (Exception e) {
            logger.error("Disconf\u914d\u7f6e\u6587\u4ef6\u9879\u76ee\u53d8\u66f4, \u6267\u884c\u64cd\u4f5c\u5931\u8d25: ", (Throwable)e);
        }
    }

    public void reload() {
        this.initDisconf();
    }
}

