package cn.com.ry.framework.linklog.httpclient.filter;

import cn.com.ry.framework.linklog.constant.LinkLogConstants;
import cn.com.ry.framework.linklog.context.LinkLogContext;
import cn.com.ry.framework.linklog.context.SpanIdGenerator;
import cn.com.ry.framework.linklog.util.HostInfo;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * HttpClient 拦截器
 */
public class LinkLogHttpRequestInterceptor implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LinkLogHttpRequestInterceptor.class);

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        //1.判断上下文有没有 traceId
        //springboot该方法有个bug
        String traceId = LinkLogContext.getTraceId();
        if (traceId != null && !traceId.equals("")) {
            String preApp = HostInfo.getAppName();
            String preHost = HostInfo.getHostName();
            String preIp = HostInfo.getIp();
            String spanId = SpanIdGenerator.generateNextSpanId();
            httpRequest.addHeader(LinkLogConstants.LINKLOG_PRE_APP_KEY, preApp);
            httpRequest.addHeader(LinkLogConstants.LINKLOG_PRE_HOST_KEY, preHost);
            httpRequest.addHeader(LinkLogConstants.LINKLOG_PRE_IP_KEY, preIp);
            httpRequest.addHeader(LinkLogConstants.LINKLOG_TRACE_KEY, traceId);
            httpRequest.addHeader(LinkLogConstants.LINKLOG_SPANID_KEY, spanId);
        } else {
            logger.debug("[LinkLog]本地threadLocal变量没有正确传递traceId,本次调用不传递traceId");
        }
    }
}
