package cn.com.ry.framework.linklog.configcenter.apollo;

import cn.com.ry.framework.linklog.logging.LinkLogSystem;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkLogApollo {


    private static final Logger logger = LoggerFactory.getLogger(LinkLogApollo.class);

    /**
     * 刷新的namespace的名字：linkLog.properties
     *
     * @param changeEvent
     */
    @ApolloConfigChangeListener("linklog.properties")
    private void changeLogLevel(ConfigChangeEvent changeEvent) {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change = changeEvent.getChange(key);
            logger.info("执行配置变更change-type:{} namespace:{} key:{} old-value:{} new-value:{}", change.getChangeType(), change.getNamespace(), key, change.getOldValue(), change.getNewValue());
            String level = change.getNewValue();
            //重置日志级别，马上生效
            LinkLogSystem.setLevel(key, level);
            logger.info("日志级别变更: logger=" + key + ", level=" + level);
        }
    }

}

