/*
 * Decompiled with CFR 0.152.
 */
package com.hagt.core.impl;

import com.alibaba.fastjson.JSON;
import com.hagt.core.Handing;
import com.hagt.core.annotation.RequestBody;
import com.hagt.core.annotation.RequestFile;
import com.hagt.core.annotation.RequestParam;
import com.hagt.core.iface.MappingFunction;
import com.hagt.core.impl.DefaultMapping;
import com.hagt.core.impl.DefaultRequestParam;
import com.hagt.core.model.MethodParam;
import com.hagt.uitl.JudgeUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultHanding
extends Handing {
    private DefaultMapping defaultMapping;

    public DefaultHanding(DefaultMapping defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    @Override
    public void handing(String requestPath, HttpServletRequest req, HttpServletResponse res, FilterChain chain) {
        this.defaultInvokeHanding(requestPath, req, res, chain);
    }

    private MappingFunction getMappingFunction(String target) {
        return this.defaultMapping.getMappingFunction(target);
    }

    private void defaultInvokeHanding(String requestPath, HttpServletRequest req, HttpServletResponse res, FilterChain chain) {
        try {
            MappingFunction mappingFunction = this.getMappingFunction(requestPath);
            if (JudgeUtil.isNull(mappingFunction)) {
                this.render("No corresponding mapping was found", res);
                return;
            }
            Method method = mappingFunction.getMethod();
            Object[] invokeMethodParams = this.getInvokeMethodParams(req, res, mappingFunction);
            Object ownerObject = mappingFunction.getOwnerObject();
            Object result = method.invoke(ownerObject, invokeMethodParams);
            this.render(result, res);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Object[] getInvokeMethodParams(HttpServletRequest req, HttpServletResponse res, MappingFunction mappingFunction) {
        int parameterCount = mappingFunction.getParameterCount();
        Map<Class, List<MethodParam>> methodParams = mappingFunction.getMethodParams();
        Object[] params = new Object[parameterCount];
        DefaultRequestParam requestParam = new DefaultRequestParam(req);
        for (Map.Entry<Class, List<MethodParam>> methodParamEntry : methodParams.entrySet()) {
            Class annotationType = methodParamEntry.getKey();
            List<MethodParam> methodParamList = methodParamEntry.getValue();
            for (MethodParam methodParam : methodParamList) {
                Object param;
                int paramIndex = methodParam.getParamIndex();
                String paramName = methodParam.getParamName();
                Class<?> paramType = methodParam.getParamType();
                if (annotationType == RequestParam.class) {
                    param = null;
                    param = paramType.isArray() ? requestParam.getParams(paramName) : requestParam.getParam(paramName);
                    params[paramIndex] = paramType.cast(param);
                }
                if (annotationType == RequestFile.class) {
                    param = null;
                    System.out.println(paramType.getTypeName());
                    if (paramType.isArray()) {
                        param = requestParam.getBinaryParams(paramName);
                    } else if (paramType == File.class) {
                        param = null;
                    }
                    params[paramIndex] = paramType.cast(param);
                }
                if (annotationType == RequestBody.class) {
                    param = requestParam.getRawData(paramName);
                    params[paramIndex] = JSON.parseObject((String)param, paramType);
                }
                if (annotationType != Parameter.class) continue;
                if (paramType == HttpServletRequest.class) {
                    params[paramIndex] = req;
                }
                if (paramType != HttpServletResponse.class) continue;
                params[paramIndex] = res;
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Object result, HttpServletResponse res) {
        PrintWriter writer = null;
        try {
            writer = res.getWriter();
            writer.print(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (JudgeUtil.isNull(writer)) {
                return;
            }
            writer.flush();
            writer.close();
        }
    }
}

