/*
 * Decompiled with CFR 0.152.
 */
package com.hagt.core;

import com.hagt.core.Handing;
import com.hagt.core.annotation.Controller;
import com.hagt.core.annotation.MappingFunction;
import com.hagt.core.annotation.RequestBody;
import com.hagt.core.annotation.RequestFile;
import com.hagt.core.annotation.RequestParam;
import com.hagt.core.annotation.Scope;
import com.hagt.core.enums.ControllerScope;
import com.hagt.core.iface.Mapping;
import com.hagt.core.impl.DefaultHanding;
import com.hagt.core.impl.DefaultMapping;
import com.hagt.core.impl.DefaultMappingFunction;
import com.hagt.core.model.MethodParam;
import com.hagt.uitl.JudgeUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MvcConfigLoad {
    private Set<String> classNames = new HashSet<String>(999);
    private Set<Class> classes = new HashSet<Class>(999);
    private Map<Class, Set<Class>> classMap = new HashMap<Class, Set<Class>>();
    private Mapping mapping;
    private Handing handing;

    public Set<String> getClassNames() {
        return this.classNames;
    }

    private void setClassNames(Set<String> classNames) {
        this.classNames = classNames;
    }

    public Set<Class> getClasses() {
        return this.classes;
    }

    private void setClasses(Set<Class> classes) {
        this.classes = classes;
    }

    private void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    private void setHanding(Handing handing) {
        this.handing = handing;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Handing getHanding() {
        return this.handing;
    }

    public Map<Class, Set<Class>> getClassMap() {
        return this.classMap;
    }

    private void setClassMap(Map<Class, Set<Class>> classMap) {
        this.classMap = classMap;
    }

    public static MvcConfigLoad load(String scanPackage) {
        String packagePath;
        MvcConfigLoad mvcLoadAndConfig = new MvcConfigLoad();
        boolean isRecursion = true;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = scanPackage.replace(".", "/"));
        String protocol = url.getProtocol();
        if (JudgeUtil.isFileString(protocol)) {
            mvcLoadAndConfig.setClassNames(MvcConfigLoad.getClassNameFromDir(url.getPath(), scanPackage, isRecursion));
            mvcLoadAndConfig.setClasses(MvcConfigLoad.loadClassAll(mvcLoadAndConfig.getClassNames()));
            mvcLoadAndConfig.setClassMap(MvcConfigLoad.loadClassMap(mvcLoadAndConfig.getClasses()));
            mvcLoadAndConfig.setMapping(MvcConfigLoad.loadMapping(mvcLoadAndConfig.getClassMap().get(Controller.class)));
            mvcLoadAndConfig.setHanding(MvcConfigLoad.loadHanding(mvcLoadAndConfig.getClassMap().get(Handing.class), mvcLoadAndConfig.getMapping()));
        }
        return mvcLoadAndConfig;
    }

    private static Map<Class, Set<Class>> loadClassMap(Set<Class> classes) {
        HashMap<Class, Set<Class>> classSetMap = new HashMap<Class, Set<Class>>();
        HashSet<Class> controllerClass = new HashSet<Class>();
        HashSet<Class> handingClass = new HashSet<Class>();
        for (Class c : classes) {
            Controller controller2 = c.getDeclaredAnnotation(Controller.class);
            if (!JudgeUtil.isNull(controller2)) {
                controllerClass.add(c);
            }
            if (c.getSuperclass() != Handing.class) continue;
            handingClass.add(c);
        }
        classSetMap.put(Controller.class, controllerClass);
        classSetMap.put(Handing.class, handingClass);
        return classSetMap;
    }

    private static Handing loadHanding(Set<Class> classes, Mapping mapping) {
        DefaultHanding lastDefaultHanding = new DefaultHanding((DefaultMapping)mapping);
        Handing handing = null;
        ArrayList defaultHandingList = new ArrayList();
        try {
            for (Class c : classes) {
                Handing tempHanding;
                if (JudgeUtil.isNull(handing)) {
                    handing = (Handing)c.newInstance();
                    continue;
                }
                handing.nextHanding = tempHanding = (Handing)c.newInstance();
                handing = tempHanding;
            }
            if (JudgeUtil.isNull(handing)) {
                handing = lastDefaultHanding;
            } else {
                handing.nextHanding = lastDefaultHanding;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return handing;
    }

    private static Mapping loadMapping(Set<Class> classes) {
        HashMap<String, com.hagt.core.iface.MappingFunction> mappingFunctions = new HashMap<String, com.hagt.core.iface.MappingFunction>();
        for (Class c : classes) {
            Method[] methods;
            Controller controller2 = c.getDeclaredAnnotation(Controller.class);
            String baseMappingUrl = controller2.baseUrl();
            for (Method method : methods = c.getMethods()) {
                MappingFunction mappingFunction = method.getDeclaredAnnotation(MappingFunction.class);
                if (JudgeUtil.isNull(mappingFunction)) continue;
                String mappingUrl = MvcConfigLoad.getMappingUrl(method, mappingFunction, baseMappingUrl);
                ControllerScope controllerScope = MvcConfigLoad.getControllerScope(c);
                int parameterCount = method.getParameterCount();
                Map<Class, List<MethodParam>> methodParams = MvcConfigLoad.getMethodParams(method);
                DefaultMappingFunction defaultMappingFunction = new DefaultMappingFunction(mappingUrl, method, c, controllerScope, parameterCount, methodParams);
                mappingFunctions.put(mappingUrl, defaultMappingFunction);
            }
        }
        DefaultMapping defaultMapping = new DefaultMapping(mappingFunctions);
        return defaultMapping;
    }

    private static Map<Class, List<MethodParam>> getMethodParams(Method method) {
        HashMap<Class, List<MethodParam>> methodParams = new HashMap<Class, List<MethodParam>>();
        Parameter[] parameters = method.getParameters();
        int paramIndex = 0;
        for (Parameter parameter : parameters) {
            String paramName;
            Class<?> paramType = parameter.getType();
            RequestParam requestParam = parameter.getDeclaredAnnotation(RequestParam.class);
            RequestFile requestFile = parameter.getDeclaredAnnotation(RequestFile.class);
            RequestBody requestBody = parameter.getDeclaredAnnotation(RequestBody.class);
            if (JudgeUtil.isNotNull(requestParam)) {
                paramName = requestParam.value();
                MvcConfigLoad.addToMethodParams(RequestParam.class, paramIndex, paramName, paramType, methodParams);
            } else if (JudgeUtil.isNotNull(requestFile)) {
                paramName = requestFile.value();
                MvcConfigLoad.addToMethodParams(RequestFile.class, paramIndex, paramName, paramType, methodParams);
            } else if (JudgeUtil.isNotNull(requestBody)) {
                paramName = requestBody.value();
                MvcConfigLoad.addToMethodParams(RequestBody.class, paramIndex, paramName, paramType, methodParams);
            } else {
                paramName = parameter.getName();
                MvcConfigLoad.addToMethodParams(Parameter.class, paramIndex, paramName, paramType, methodParams);
            }
            ++paramIndex;
        }
        return methodParams;
    }

    private static void addToMethodParams(Class type, int paramIndex, String paramName, Class paramType, Map<Class, List<MethodParam>> methodParams) {
        List<MethodParam> methodParamsList = methodParams.get(type);
        MethodParam methodParam = new MethodParam(paramIndex, paramName, paramType);
        if (JudgeUtil.isNotNull(methodParamsList)) {
            methodParamsList.add(methodParam);
        } else {
            methodParamsList = new ArrayList<MethodParam>();
            methodParamsList.add(methodParam);
        }
        methodParams.put(type, methodParamsList);
    }

    private static ControllerScope getControllerScope(Class c) {
        Scope scope = c.getDeclaredAnnotation(Scope.class);
        ControllerScope controllerScope = ControllerScope.SINGLETON;
        if (JudgeUtil.isNotNull(scope)) {
            controllerScope = scope.getScope();
        }
        return controllerScope;
    }

    private static String getMappingUrl(Method method, MappingFunction mappingFunction, String baseMappingUrl) {
        String methodName = method.getName();
        String mapingUrl = mappingFunction.url();
        if (JudgeUtil.isNull(mapingUrl)) {
            mapingUrl = MvcConfigLoad.formatMappingUrl(methodName);
        }
        if (JudgeUtil.isNotNull(baseMappingUrl)) {
            mapingUrl = MvcConfigLoad.formatMappingUrl(baseMappingUrl) + MvcConfigLoad.formatMappingUrl(mapingUrl);
        }
        return mapingUrl;
    }

    private static String formatMappingUrl(String mapingUrl) {
        if (!mapingUrl.startsWith("/")) {
            mapingUrl = "/" + mapingUrl;
        }
        return mapingUrl.replaceAll("/+", "/");
    }

    private static Set<Class> loadClassAll(Set<String> classNames) {
        HashSet<Class> classes = new HashSet<Class>();
        ClassLoader classLoader = MvcConfigLoad.class.getClassLoader();
        try {
            for (String className : classNames) {
                Class<?> aClass = classLoader.loadClass(className);
                classes.add(aClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static Set<String> getClassNameFromDir(String filePath, String packageName, boolean isRecursion) {
        File[] files;
        HashSet<String> className = new HashSet<String>();
        File file = new File(filePath);
        for (File childFile : files = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!isRecursion) continue;
                className.addAll(MvcConfigLoad.getClassNameFromDir(childFile.getPath(), packageName + "." + childFile.getName(), isRecursion));
                continue;
            }
            String fileName = childFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            className.add(packageName + "." + fileName.replace(".class", ""));
        }
        return className;
    }
}

