/*
 * Decompiled with CFR 0.152.
 */
package com.hagt.core.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hagt.core.enums.RequestContentType;
import com.hagt.core.enums.RequestType;
import com.hagt.core.iface.GetRequestParam;
import com.hagt.uitl.JudgeUtil;
import com.hagt.uitl.MapUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class DefaultRequestParam
implements GetRequestParam {
    private HttpServletRequest request;
    private String requestContentType;
    private String rowData;
    JSONObject rowDataJSON;
    private Map<String, String[]> parameterMap;

    public DefaultRequestParam(HttpServletRequest request) {
        this.requestContentType = request.getHeader("content-type");
        if (JudgeUtil.isNull(this.requestContentType)) {
            this.requestContentType = request.getContentType();
        }
        this.request = request;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.parameterMap = MapUtil.copyMap(this.request.getParameterMap());
        if (this.requestContentType.startsWith(RequestContentType.MULTIPART_FORM_DATA.getTypeValue())) {
            ServletInputStream inputStream = null;
            try {
                inputStream = this.request.getInputStream();
                String boundary = "--" + this.requestContentType.split("=")[1];
                int contentLength = this.request.getContentLength();
                byte[] listByte = new byte[contentLength];
                int length = 0;
                int readLength = 0;
                int readCount = 0;
                int b = -1;
                block11: while (true) {
                    byte by = (byte)inputStream.read();
                    b = by;
                    if (by == -1) break;
                    if (b == 13) {
                        String content = new String(listByte, readLength, length - readLength);
                        if (content.contains(boundary + "--")) {
                        }
                        if (content.startsWith(boundary)) {
                            readCount = 1;
                            readLength = length + 1 + readCount;
                        } else if (content.contains("Content-Disposition:")) {
                            String[] splitContent;
                            for (String attr : splitContent = content.split(";")) {
                                Object object;
                                Object[] splitAttr = attr.replaceAll("\"", "").trim().split("=");
                                if (JudgeUtil.isEmptyArray(splitAttr)) continue;
                                if (((String)splitAttr[0]).equals("name")) {
                                    object = splitAttr[1];
                                }
                                if (!((String)splitAttr[0]).equals("filename")) continue;
                                object = splitAttr[1];
                            }
                            readCount = 1;
                            readLength = length + 1 + readCount;
                        } else if (content.contains("Content-Type:")) {
                            String type = content.split(":")[1].trim();
                            readCount = 1;
                            readLength = length + readCount;
                        } else {
                            if (JudgeUtil.isNotNull(content)) {
                                // empty if block
                            }
                            readCount = 2;
                            readLength = length + readCount;
                        }
                    }
                    listByte[length] = b;
                    ++length;
                    while (true) {
                        if (readCount <= 0) continue block11;
                        listByte[length] = b = (int)((byte)inputStream.read());
                        ++length;
                        --readCount;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (JudgeUtil.isNotNull(inputStream)) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (RequestType.POST == RequestType.valueOf(this.request.getMethod())) {
            this.rowData = this.getPostData();
        }
        if (RequestContentType.APPLICATION_JSON.getTypeValue().equals(this.requestContentType)) {
            this.rowDataJSON = JSON.parseObject((String)this.rowData);
        }
    }

    private String getPostData() {
        BufferedReader br = null;
        try {
            StringBuilder ret;
            br = new BufferedReader(new InputStreamReader((InputStream)this.request.getInputStream(), "UTF-8"));
            String line = br.readLine();
            if (line != null) {
                ret = new StringBuilder();
                ret.append(line);
            } else {
                return "";
            }
            while ((line = br.readLine()) != null) {
                ret.append('\n').append(line);
            }
            return ret.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRawData(String name) {
        if (JudgeUtil.isNull(name)) {
            return this.rowData;
        }
        if (JudgeUtil.isNull(this.rowDataJSON)) {
            return null;
        }
        String[] indexPaths = name.split("\\.");
        JSONObject result = null;
        for (String indexPath : indexPaths) {
            result = JudgeUtil.isNull(result) ? this.rowDataJSON.getJSONObject(indexPath) : result.getJSONObject(indexPath);
        }
        return JudgeUtil.isNull(result) ? null : result.toJSONString();
    }

    @Override
    public String getParam(String name) {
        Object[] v = this.parameterMap.get(name);
        if (JudgeUtil.isEmptyArray(v)) {
            return null;
        }
        return v[0];
    }

    @Override
    public String[] getParams(String name) {
        Object[] v = this.parameterMap.get(name);
        if (JudgeUtil.isEmptyArray(v)) {
            return null;
        }
        return v;
    }

    @Override
    public String getRequestContentType() {
        return this.requestContentType;
    }
}

