package com.me.arms.http.imageloader.glide;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Author: lhy
 * @CreateDate: 3/16/21
 * @Description: Incremental change is better than ambitious failure.
 * see {@link com.bumptech.glide.load.engine.DiskCacheStrategy}
 */
public interface CacheStrategy {


    int ALL = 0;

    int NONE = 1;

    int RESOURCE = 2;

    int DATA = 3;

    int AUTOMATIC = 4;

    @IntDef({ALL, NONE, RESOURCE, DATA, AUTOMATIC})
    @Retention(RetentionPolicy.SOURCE)
    @interface Strategy {
    }

}
