package com.me.art.mvp;

import android.app.Activity;

/**
 * @Author: lihanyang
 * @CreateDate: 11/30/20
 * @Description: 要求框架中的每个 Presenter 都需要实现此类，以满足规范
 */
public interface IPresenter {

    /**
     * 初始化操作
     */
    void onStart();

    /**
     * 在框架中 {@link Activity#onDestroy()} 时会默认调用 {@link IPresenter#onDestroy()} }
     */
    void onDestroy();
}
