package com.me.art.base.delegate;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.Nullable;

/**
 * {@link Activity} 代理类,用于框架内部在每个 {@link android.app.Activity} 的对应生命周期中插入需要的逻辑
 *
 * @see ActivityDelegateImpl
 *
 * @Author: lhy
 * @CreateDate: 3/9/21
 * @Description:
 */
public interface ActivityDelegate {
    String LAYOUT_LINEARLAYOUT = "LinearLayout";
    String LAYOUT_FRAMELAYOUT = "FrameLayout";
    String LAYOUT_RELATIVELAYOUT = "RelativeLayout";
    String ACTIVITY_DELEGATE = "ACTIVITY_DELEGATE";

    void onCreate(@Nullable Bundle savedInstanceState);

    void onStart();

    void onResume();

    void onPause();

    void onStop();

    void onSaveInstanceState(@Nullable Bundle outState);

    void onDestroy();
}
