package com.me.arms.integration;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.me.arms.mvp.IModel;

import retrofit2.Retrofit;

/**
 * @Author: lihanyang
 * @CreateDate: 2019/12/6
 * @Description: 用来管理网络请求层, 以及数据缓存层, 以后可能添加数据库请求层
 * 提供给 {@link IModel} 必要的 Api 做数据处理
 */
public interface IRepositoryManager {

    /**
     * 根据传入的 Class 获取对应的 Retrofit service
     *
     * @param service Retrofit service class
     * @param <T>     Retrofit service 类型
     * @return Retrofit service
     */
    @NonNull
    <T> T obtainRetrofitService(@NonNull Class<T> service);


    /**
     * 根据传入的 Class 获取对应的 RxCache service
     *
     * @param cache RxCache service class
     * @param <T>   RxCache service 类型
     * @return RxCache service
     */
    @NonNull
    <T> T obtainCacheService(@NonNull Class<T> cache);

    /**
     * 清理所有缓存
     */
    void clearAllCache();

    /**
     * 获取 {@link Context}
     *
     * @return {@link Context}
     */
    @NonNull
    Context getContext();

    interface ObtainServiceDelegate {

        @Nullable
        <T> T createRetrofitService(Retrofit retrofit, Class<T> serviceClass);
    }
}
