package com.me.arms.http.imageloader;

import android.content.Context;

import androidx.annotation.Nullable;

/**
 * @Author: lihanyang
 * @CreateDate: 2019/12/16
 * @Description: 图片加载策略，实现 {@link BaseImageLoaderStrategy}
 * 并通过{@link ImageLoader}
 */
public interface BaseImageLoaderStrategy<T extends ImageConfig> {

    /**
     * 加载图片
     *
     * @param ctx    {@link Context}
     * @param config 图片加载配置信息
     */
    void loadImage(@Nullable Context ctx, @Nullable T config);


    /**
     * 停止加载
     *
     * @param ctx    {@link Context}
     * @param config 图片加载配置信息
     */
    void clear(@Nullable Context ctx, @Nullable T config);

}
