package com.me.arms.mvp;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;

import com.me.arms.integration.IRepositoryManager;

/**
 * @Author: lihanyang
 * @CreateDate: 2019/12/6
 * @Description: 基类 Model
 */
public class BaseModel implements IModel, LifecycleObserver {
    protected IRepositoryManager mRepositoryManager;//用于管理网络请求层，以及数据缓存层

    public BaseModel(IRepositoryManager mRepositoryManager) {
        this.mRepositoryManager = mRepositoryManager;
    }

    /**
     * 在框架中 {@link BasePresenter#onDestroy()} 时会默认调用 {@link IModel#onDestroy()}
     */
    @Override
    public void onDestroy() {
        mRepositoryManager = null;
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    void onDestroy(LifecycleOwner owner) {
        owner.getLifecycle().removeObserver(this);
    }
}
