package com.hx.lib_common.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/10/16 15:20
 * Describe:
 */
public class RectObject {

    /**
     * 调整srcSize大小到desSize大小
     */
    public static Rect getFitRect(Size srcSize, Size desSize){
        int w = desSize.getWidth()*srcSize.getHeight()/desSize.getHeight();
        if (w <= srcSize.getWidth()){
            return new Rect((srcSize.getWidth() - w)/2, 0, (srcSize.getWidth() + w)/2, srcSize.getHeight());
        }
        else {
            int h = srcSize.getWidth()*desSize.getHeight()/desSize.getWidth();
            return new Rect(0, (srcSize.getHeight()-h)/2, srcSize.getWidth(), (srcSize.getHeight()+h)/2);
        }
    }

    private RectF rect;
    public static RectObject of(RectF rectF){
        return new RectObject(rectF);
    }

    public static RectObject of(Rect rect){
        return new RectObject(new RectF(rect));
    }

    private RectObject(RectF rect){
        this.rect = rect;
    }

    public RectF getRectF(){
        return rect;
    }

    public Rect getRect(){
        Rect rect = new Rect();
        this.rect.round(rect);
        return rect;
    }
    /**
     * 中心放大缩小
     * @param scale
     */
    public RectObject scaleByCenter(float scale){
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale, rect.width()/2, rect.height()/2);
        matrix.mapRect(rect);
        return this;
    }

    /**
     * 偏移
     * @param dx
     * @param dy
     * @return
     */
    public RectObject translate(float dx, float dy){
        Matrix matrix = new Matrix();
        matrix.setTranslate(dx, dy);
        matrix.mapRect(rect);
        return this;
    }

    /**
     * 放大缩小原矩阵居中映射到另一个矩阵
     * @param dst
     * @return
     */
    public RectObject map2RectCenter(RectF dst){
        Matrix matrix = new Matrix();
        matrix.setRectToRect(rect, dst, Matrix.ScaleToFit.CENTER);
        matrix.mapRect(rect);
        return this;
    }
    /**
     * 放大缩小原矩阵映射到另一个矩阵的开始
     * @param dst
     * @return
     */
    public RectObject map2RectStart(RectF dst){
        Matrix matrix = new Matrix();
        matrix.setRectToRect(rect, dst, Matrix.ScaleToFit.START);
        matrix.mapRect(rect);
        return this;
    }
    /**
     * 放大缩小原矩阵映射到另一个矩阵的结束
     * @param dst
     * @return
     */
    public RectObject map2RectEnd(RectF dst){
        Matrix matrix = new Matrix();
        matrix.setRectToRect(rect, dst, Matrix.ScaleToFit.END);
        matrix.mapRect(rect);
        return this;
    }

    /**
     * 放大缩小原矩阵完全填充映射到另一个矩阵
     * @param dst
     * @return
     */
    public RectObject map2RectFill(RectF dst){
        Matrix matrix = new Matrix();
        matrix.setRectToRect(rect, dst, Matrix.ScaleToFit.FILL);
        matrix.mapRect(rect);
        return this;
    }


    /**
     * 边界检测
     * @param left
     * @param top
     * @param right
     * @param bottom
     * @return
     */
    public RectObject checkBorder(float left, float top, float right, float bottom){
        if (rect.left < left){
            rect.left = left;
        }
        if (rect.top < top){
            rect.top = top;
        }
        if (rect.right > right){
            rect.right = right;
        }
        if (rect.bottom > bottom){
            rect.bottom = bottom;
        }
        return this;
    }

    public RectObject checkBorder(float right, float bottom){
        return checkBorder(0f, 0f, right, bottom);
    }

}
