package com.hx.lib_common.utils;

import android.os.SystemClock;

import androidx.annotation.NonNull;

/**
 * Copyright © 1997 - 2021 Gosuncn. All Rights Reserved
 * Created by huangxi on 2021/6/3 14:09
 * Describe:
 * 网络速度工具类
 */
public class NetworkSpeedObject {

    private long lastTime = 0;
    private NetworkUtils.FlowInfo lastFlowInfo;

    /**
     * 获取网络速度
     * @param flowInfo @see NetworkUtils.getEthernetFlowInfo()
     * @return
     */
    public @NonNull NetworkSpeedInfo getNetworkSpeedInfo(NetworkUtils.FlowInfo flowInfo){
        long uploadSpeed = 0;
        long downloadSpeed = 0;
        long currentTime = SystemClock.elapsedRealtime();
        if (!(lastTime == 0 || lastFlowInfo == null || flowInfo == null || currentTime < lastTime)){
            uploadSpeed = (flowInfo.getUploadBytes() - lastFlowInfo.getUploadBytes())*1000/(currentTime - lastTime);
            downloadSpeed = (flowInfo.getDownloadBytes() - lastFlowInfo.getDownloadBytes())*1000/(currentTime - lastTime);
        }
        lastTime = currentTime;
        lastFlowInfo = flowInfo;
        return new NetworkSpeedInfo(uploadSpeed, downloadSpeed);
    }

    public static class NetworkSpeedInfo{
        /**上行的网速，byte/s*/
        private long uploadSpeed;
        /**下行的网速，byte/s*/
        private long downloadSpeed;

        public NetworkSpeedInfo(long uploadSpeed, long downloadSpeed) {
            this.uploadSpeed = uploadSpeed;
            this.downloadSpeed = downloadSpeed;
        }

        public long getDownloadSpeed() {
            return downloadSpeed;
        }

        public long getUploadSpeed() {
            return uploadSpeed;
        }

        @Override
        public String toString() {
            return "NetworkSpeedInfo{" +
                    "uploadSpeed=" + uploadSpeed +
                    ", downloadSpeed=" + downloadSpeed +
                    '}';
        }
    }
}
