package com.hx.lib_common.utils;

import android.graphics.Rect;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/10/15 16:51
 * Describe:
 */
public class NV21Utils {

    /**
     * yuv420data 顺时钏旋转90度
     *
     * @param yuv420data
     * @param imageWidth
     * @param imageHeight
     * @return
     */
    public static byte[] rotate90(byte[] yuv420data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        // Rotate the Y luma
        int i = 0;
        for (int x = 0; x < imageWidth; x++) {
            for (int y = imageHeight - 1; y >= 0; y--) {
                yuv[i] = yuv420data[y * imageWidth + x];
                i++;
            }
        }
        // Rotate the U and V color components
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (int x = imageWidth - 1; x > 0; x = x - 2) {
            for (int y = 0; y < imageHeight / 2; y++) {
                yuv[i] = yuv420data[(imageWidth * imageHeight) + (y * imageWidth) + x];
                i--;
                yuv[i] = yuv420data[(imageWidth * imageHeight) + (y * imageWidth) + (x - 1)];
                i--;
            }
        }
        return yuv;
    }

    /**
     * 顺时针旋转180度
     * @param yuv420data
     * @param imageWidth
     * @param imageHeight
     * @return
     */
    public static byte[] rotate180(byte[] yuv420data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int i = 0;
        int count = 0;

        for (i = imageWidth * imageHeight - 1; i >= 0; i--) {
            yuv[count] = yuv420data[i];
            count++;
        }
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (i = imageWidth * imageHeight * 3 / 2 - 1; i >= imageWidth * imageHeight; i -= 2) {
            yuv[count++] = yuv420data[i - 1];
            yuv[count++] = yuv420data[i];
        }
        return yuv;
    }

    /**
     * 顺时针旋转270度
     * @param yuv420data
     * @param imageWidth
     * @param imageHeight
     * @return
     */
    public static byte[] rotate270(byte[] yuv420data, int imageWidth, int imageHeight) {

        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        // Rotate the Y luma
        int i = 0;
        for (int x = imageWidth - 1; x >= 0; x--) {
            for (int y = 0; y < imageHeight; y++) {
                yuv[i] = yuv420data[y * imageWidth + x];
                i++;
            }
        }// Rotate the U and V color components
        i = imageWidth * imageHeight;
        for (int x = imageWidth - 1; x > 0; x = x - 2) {
            for (int y = 0; y < imageHeight / 2; y++) {
                yuv[i] = yuv420data[(imageWidth * imageHeight) + (y * imageWidth) + (x - 1)];
                i++;
                yuv[i] = yuv420data[(imageWidth * imageHeight) + (y * imageWidth) + x];
                i++;
            }
        }
        return yuv;
    }


    /**
     * 左右镜像
     * @param yuv420data
     * @param w
     * @param h
     */
    public static void mirror(byte[] yuv420data, int w, int h) {
        int i;
        int a, b;
        byte temp;
        //mirror y
        for (i = 0; i < h; i++) {
            a = i * w;
            b = (i + 1) * w - 1;
            while (a < b) {
                temp = yuv420data[a];
                yuv420data[a] = yuv420data[b];
                yuv420data[b] = temp;
                a++;
                b--;
            }
        }
        //mirror vu
        int uvIndex = w * h;
        for (i = 0; i < h/2; i++){
            a = i * w;
            b = (i + 1) * w - 2;
            while (a < b) {
                temp = yuv420data[a + uvIndex];
                yuv420data[a + uvIndex] = yuv420data[b + uvIndex];
                yuv420data[b + uvIndex] = temp;
                temp = yuv420data[a + uvIndex + 1];
                yuv420data[a + uvIndex + 1] = yuv420data[b + uvIndex + 1];
                yuv420data[b + uvIndex + 1] = temp;
                a += 2;
                b -= 2;
            }
        }
    }

    /**
     * 裁剪
     * @param yuv420data 原数据
     * @param dataW 原数据w
     * @param dataH 原数据h
     * @param rect 裁剪矩阵（会更新）
     * @return 裁剪后的数据
     */
    public static byte[] clip(byte[] yuv420data, int dataW, int dataH, Rect rect){
        //取整(4的倍数)
        int x = rect.left/4*4, y = rect.top/4*4;
        int w = rect.width()/4*4, h = rect.height()/4*4;
        rect.set(x, y, x+w, y+h);

        int yTotal = dataW*dataH;
        int yTotalNew = w*h;
        byte newData[] = new byte[yTotalNew*3/2];
        for (int i = 0; i < h; i++){
            //copy y
            System.arraycopy(yuv420data, (i+y)*dataW+x, newData, i*w, w);
            //copy vu
            if (i%2 == 0){
                System.arraycopy(yuv420data, yTotal+x + ((i+y)>>1)*dataW, newData, yTotalNew+((i+y)>>1)*w, w);
            }
        }
        return newData;
    }

}
