package com.hx.lib_common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/12/14 16:32
 * Describe:
 * 全局的GSon转换工具类，如果只希望用到局部的转换，可以使用 GSonObject
 */
public class GSonUtils {

    private static Gson gson;
    static {
        gson = new Gson();
    }

    /**
     * 对象转换成Json 字符串
     * @param data
     * @return
     */
    public static String toJson(Object data){
        return gson.toJson(data);
    }

    /**
     * 对象转成JsonElement
     * @param data
     * @return
     */
    public static JsonElement toJsonTree(Object data){
        return gson.toJsonTree(data);
    }

    /**
     * json字符串转成JavaBean
     * @param json
     * @param classOfT
     * @param <T>
     * @return
     */
    public static <T> T jsonToBean(String json, Class<T> classOfT){
        return gson.fromJson(json, classOfT);
    }

    /**
     * JsonElement转成JavaBean
     * @param element
     * @param classOfT
     * @param <T>
     * @return
     */
    public static <T> T jsonToBean(JsonElement element, Class<T> classOfT){
        return gson.fromJson(element, classOfT);
    }


    /**
     * json转换成List,在转换前可通过JsonElement.isJsonArray()来判断是否是List
     * @param json，可为JsonArray.toString
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> List<T> jsonToList(String json, Class<T> cls) {
        Type type = new ParameterizedTypeImpl(cls);
        return gson.fromJson(json, type);
    }

    private static class ParameterizedTypeImpl implements ParameterizedType {
        Class clazz;

        ParameterizedTypeImpl(Class clz) {
            clazz = clz;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{clazz};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    /**
     * json转换成有map的List
     *
     * @param json
     * @return
     */
    public static <T> List<Map<String, T>> jsonToListMaps(String json) {
        return gson.fromJson(json,
                    new TypeToken<List<Map<String, T>>>() {
                    }.getType());
    }

    /**
     * json转换成map
     *
     * @param json
     * @return
     */
    public static <T> Map<String, T> jsonToMaps(String json) {
        return gson.fromJson(json, new TypeToken<Map<String, T>>() {}.getType());
    }
}
