package com.hx.lib_common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/12/14 16:32
 * Describe:
 * 局部的GSon转换工具类，如果只希望用到全局的转换，可以使用 GSonUtils
 */
public class GSonObject {

    private Gson gson = new Gson();

    public String toJson(Object data){
        return gson.toJson(data);
    }

    public JsonElement toJsonTree(Object data){
        return gson.toJsonTree(data);
    }

    public <T> T fromJson(String json, Class<T> classOfT){
        return gson.fromJson(json, classOfT);
    }

    public <T> T fromJson(JsonElement element, Class<T> classOfT){
        return gson.fromJson(element, classOfT);
    }



}
