package com.hx.lib_common.utils;

import com.hx.lib_common.constant.EncryptType;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/2 9:38
 * Describe:
 * 加密工具
 */
public class EncryptUtils {

    /**
     * 字符串加密成hex字符串
     * @param data
     * @param type
     * @return
     */
    public static String encryptToString(final String data, @EncryptType.Type String type){
        if (StringUtils.isEmpty(data)) return null;
        return encryptToString(data.getBytes(), type);
    }

    /**
     * 数组加密成hex字符串
     * @param data
     * @param type
     * @return
     */
    public static String encryptToString(final byte[] data, @EncryptType.Type String type){
        return ConvertUtils.bytes2HexString(encrypt(data, type));
    }

    /**
     * 数组加密成数组
     * @param data
     * @param type
     * @return
     */
    public static byte[] encrypt(final byte[] data, @EncryptType.Type String type){
        return hashTemplate(data, type);
    }

    /**
     * MD2加密
     * @param data
     * @return
     */
    public static String encryptMD2ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptMD2ToString(data.getBytes());
    }

    /**
     * MD2加密
     * @param data
     * @return
     */
    public static String encryptMD2ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptMD2(data));
    }

    /**
     * MD2加密
     * @param data
     * @return
     */
    public static byte[] encryptMD2(final byte[] data) {
        return hashTemplate(data, "MD2");
    }

    /**
     * MD5加密成hex字符串
     * @param data
     * @return
     */
    public static String encryptMD5ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptMD5ToString(data.getBytes());
    }

    /**
     * 数组MD5加密成hex字符串
     * @param data
     * @return
     */
    public static String encryptMD5ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptMD5(data));
    }

    /**
     * 文件MD5加密成hex串
     * @param filePath
     * @return
     */
    public static String encryptMD5File2String(final String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return encryptMD5File2String(file);
    }

    /**
     * 文件MD5加密成hex数组
     * @param filePath
     * @return
     */
    public static byte[] encryptMD5File(final String filePath) {
        File file = StringUtils.isSpace(filePath) ? null : new File(filePath);
        return encryptMD5File(file);
    }

    /**
     * 文件MD5加密成hex串
     * @param file
     * @return
     */
    public static String encryptMD5File2String(final File file) {
        return ConvertUtils.bytes2HexString(encryptMD5File(file));
    }

    /**
     * 文件MD5加密成hex数组
     * @param file
     * @return
     */
    public static byte[] encryptMD5File(final File file) {
        if (file == null) return null;
        FileInputStream fis = null;
        DigestInputStream digestInputStream = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[256 * 1024];
            while (true) {
                if (!(digestInputStream.read(buffer) > 0)) break;
            }
            md = digestInputStream.getMessageDigest();
            return md.digest();
        } catch (NoSuchAlgorithmException | IOException e) {
            e.printStackTrace();
            return null;
        } finally {
            CloseUtils.closeIO(fis, digestInputStream);
        }
    }

    /**
     * MD5加密
     * @param data
     * @return
     */
    public static byte[] encryptMD5(final byte[] data) {
        return hashTemplate(data, "MD5");
    }

    /**
     * SHA1加密成hex字符串
     * @param data
     * @return
     */
    public static String encryptSHA1ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptSHA1ToString(data.getBytes());
    }

    /**
     * SHA1加密成hex字符串
     * @param data
     * @return
     */
    public static String encryptSHA1ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptSHA1(data));
    }

    /**
     * SHA1加密成hex 数组
     * @param data
     * @return
     */
    public static byte[] encryptSHA1(final byte[] data) {
        return hashTemplate(data, "SHA-1");
    }

    /**
     * SHA224加密
     * @param data
     * @return
     */
    public static String encryptSHA224ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptSHA224ToString(data.getBytes());
    }

    /**
     * SHA224加密
     * @param data
     * @return
     */
    public static String encryptSHA224ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptSHA224(data));
    }

    /**
     * SHA224加密
     * @param data
     * @return
     */
    public static byte[] encryptSHA224(final byte[] data) {
        return hashTemplate(data, "SHA224");
    }

    /**
     * SHA256加密
     * @param data
     * @return
     */
    public static String encryptSHA256ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptSHA256ToString(data.getBytes());
    }

    /**
     * SHA256加密
     * @param data
     * @return
     */
    public static String encryptSHA256ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptSHA256(data));
    }

    /**
     * SHA256加密
     * @param data
     * @return
     */
    public static byte[] encryptSHA256(final byte[] data) {
        return hashTemplate(data, "SHA-256");
    }

    /**
     * SHA384加密
     * @param data
     * @return
     */
    public static String encryptSHA384ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptSHA384ToString(data.getBytes());
    }

    /**
     * SHA384加密
     * @param data
     * @return
     */
    public static String encryptSHA384ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptSHA384(data));
    }

    /**
     * SHA384加密
     * @param data
     * @return
     */
    public static byte[] encryptSHA384(final byte[] data) {
        return hashTemplate(data, "SHA-384");
    }

    /**
     * SHA512加密
     * @param data
     * @return
     */
    public static String encryptSHA512ToString(final String data) {
        if (StringUtils.isEmpty(data)) return "";
        return encryptSHA512ToString(data.getBytes());
    }

    /**
     * SHA512加密
     * @param data
     * @return
     */
    public static String encryptSHA512ToString(final byte[] data) {
        return ConvertUtils.bytes2HexString(encryptSHA512(data));
    }

    /**
     * SHA512加密
     * @param data
     * @return
     */
    public static byte[] encryptSHA512(final byte[] data) {
        return hashTemplate(data, "SHA-512");
    }

    /**
     * 加密成hex 数组
     * @param data
     * @param algorithm
     * @return
     */
    private static byte[] hashTemplate(final byte[] data, final String algorithm) {
        if (data == null || data.length <= 0) return null;
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

}
