package com.hx.lib_common.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

/**
 * Copyright © 1997 - 2021 Gosuncn. All Rights Reserved
 * Created by huangxi on 2021/7/7 14:40
 * Describe:
 * 显示类工具类
 */
public class DisplayUtils {

    /**
     * 隐藏导航栏
     * @param activity
     */
    public static void hideNavigationBar(Activity activity){
        hideNavigationBar(activity.getWindow().getDecorView());
    }

    /**
     * 隐藏导航栏
     * @param view
     */
    public static void hideNavigationBar(View view){
        int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_FULLSCREEN;
        view.setSystemUiVisibility(uiOptions);
    }

    /**
     * 显示输入法
     * @param activity
     */
    public static void showSoftInput(Activity activity){
        showSoftInput(activity.getCurrentFocus());
    }

    /**
     *  显示输入法
     * @param focusView 已经有焦点的View，如果没有焦点，可通过下面方法
     *  view.setFocusable(true);
     *  view.setFocusableInTouchMode(true);
     *  view.requestFocus();
     */
    public static void showSoftInput(View focusView){
        if (focusView == null){
            return;
        }
        InputMethodManager imm = (InputMethodManager) focusView.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(focusView, InputMethodManager.SHOW_FORCED);
    }

    /**
     * 隐藏输入法
     * @param activity
     */
    public static void hideSoftInput(Activity activity){
        hideSoftInput(activity.getCurrentFocus());
    }

    /**
     * 隐藏输入法
     * @param focusView 获取焦点的View
     */
    public static void hideSoftInput(View focusView){
        InputMethodManager imm = (InputMethodManager) focusView.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm.isActive() && focusView != null) {
            imm.hideSoftInputFromWindow(focusView.getWindowToken(), 0);
        }
    }

}
