package com.hx.lib_common.log;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/27 16:59
 * Describe:
 * HLog的配置，只有配置了HLogConfig，HLog才有作用
 */
public class HLogConfig {
    private boolean androidLogEnable = true;
    private boolean fileLogEnable = false;
    private IFileLogConfig fileLog = null;
    private boolean newFileEveryDay = true;

    private static final class SingletonHolder {
        private static final HLogConfig INSTANCE = new HLogConfig();
    }

    public static HLogConfig getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private HLogConfig() {
    }

    public HLogConfig setAndroidLogEnable(boolean enable) {
        androidLogEnable = enable;
        return this;
    }

    public boolean getAndroidLogEnable() {
        return androidLogEnable;
    }

    public HLogConfig setFileLogEnable(boolean enable) {
        fileLogEnable = enable;
        return this;
    }

    public boolean getFileLogEnable() {
        return fileLogEnable;
    }

    public boolean isNewFileEveryDay() {
        return newFileEveryDay;
    }

    public HLogConfig setNewFileEveryDay(boolean newFileEveryDay) {
        this.newFileEveryDay = newFileEveryDay;
        return this;
    }

    public HLogConfig setIFileLogConfig(IFileLogConfig fileLog){
        this.fileLog = fileLog;
        if (fileLog != null){
            fileLog.initConfig();
        }
        return this;
    }

    /**
     * 重新初始化配置，以达到隔天生成新文件的目的
     */
    public void reInitConfig(){
        if (this.fileLog != null){
            this.fileLog.initConfig();
        }
    }

}
