package com.hx.lib_common.annotation.aspectj;

import com.hx.lib_common.annotation.LimitClick;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/29 15:20
 * Describe:
 */
@Aspect
public class LimitClickAspectJ {

    private long mLastClickTime = 0;

    @Pointcut("execution(@com.hx.lib_common.annotation.LimitClick * *(..)) && @annotation(anno)")
    public void annotationPointcut(LimitClick anno){}

    @Around("annotationPointcut(anno)")
    public Object aroundPointCut(ProceedingJoinPoint joinPoint, LimitClick anno) throws Throwable{
        long timeDiff = anno.timeDiff();
        long currentTimeMillis = System.currentTimeMillis();

        if (currentTimeMillis - mLastClickTime < timeDiff) {
            return null;
        }
        mLastClickTime = currentTimeMillis;
        return joinPoint.proceed();
    }
}
