package com.hx.lib_common.utils;

import android.content.Context;
import android.speech.tts.TextToSpeech;
import android.widget.Toast;

import java.util.Locale;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/2 16:50
 * Describe:
 */
public class TtsUtils {

    private TextToSpeech mTextToSpeech;
    private Context mContext;

    private static final class SingletonHolder {
        private static final TtsUtils INSTANCE = new TtsUtils();
    }

    public static TtsUtils getInstance(){
        return SingletonHolder.INSTANCE;
    }

    private TtsUtils(){

    }

    /**
     * 初始化
     */
    public void init(Context context){
        mContext = context.getApplicationContext();
        mTextToSpeech = new TextToSpeech(mContext, new TextToSpeech.OnInitListener() {
            @Override
            public void onInit(int status) {
                if (status == TextToSpeech.SUCCESS) {
                    int result = mTextToSpeech.setLanguage(Locale.CHINA);
                    if (result == TextToSpeech.LANG_MISSING_DATA || result == TextToSpeech.LANG_NOT_SUPPORTED) {
                        Toast.makeText(mContext, "语音数据丢失或不支持", Toast.LENGTH_LONG).show();
                    }
                }
            }
        });
    }

    /**
     * 朗读
     * @param message
     */
    public void speak(String message){
        if (mTextToSpeech != null && !mTextToSpeech.isSpeaking()) {
            mTextToSpeech.setPitch(1.2f);// 设置音调，值越大声音大
            mTextToSpeech.speak(message, TextToSpeech.QUEUE_FLUSH, null);
        }
    }

    /**
     * 停止朗读
     */
    public void stopSpeak(){
        if (mTextToSpeech != null) {
            mTextToSpeech.stop();//停止朗读
        }
    }

    /**
     * 释放资源
     */
    public void release(){
        if (mTextToSpeech != null) {
            mTextToSpeech.shutdown();
        }
    }
}
