package com.hx.lib_common.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;

import com.google.gson.Gson;

import java.lang.reflect.Type;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/10 8:44
 * Describe:SharedPreferences封装类
 */
public class SPUtils {
    private static SharedPreferences settings = null;


    private static SharedPreferences getSettings(){
        if (settings == null){
            settings = PreferenceManager.getDefaultSharedPreferences(AppUtils.getApplication());
        }
        return settings;
    }

    /**
     * 可调用此方法来修改SP名称
     * @param name
     */
    public static void initSharedPreferences(String name){
        settings = AppUtils.getApplication().getSharedPreferences(name, Context.MODE_PRIVATE);
    }


    /**
     * 存储String类型数据
     * @param key 键
     * @param value 值
     */
    public static void putString(String key, String value) {
        getSettings().edit().putString(key, value).commit();
    }

    /**
     * 获取String类型数据
     * @param key 键
     * @param defaultValue 默认值
     * @return 值
     */
    public static String getString(String key, String defaultValue) {
        return getSettings().getString(key, defaultValue);
    }

    /**
     * 存储boolean类型数据
     * @param key 键
     * @param value 值
     */
    public static void putBoolean(String key, boolean value) {
        getSettings().edit().putBoolean(key, value).commit();
    }

    /**
     * 获取boolean类型数据
     * @param key 键
     * @param defaultValue 默认值
     * @return 值
     */
    public static boolean getBoolean(String key, boolean defaultValue) {
        return getSettings().getBoolean(key, defaultValue);
    }

    /**
     * 存储int类型数据
     * @param key 键
     * @param value 值
     */
    public static void putInt(String key, int value) {
        getSettings().edit().putInt(key, value).commit();
    }

    /**
     * 获取int类型数据
     * @param key 键
     * @param defaultValue 默认值
     * @return 值
     */
    public static int getInt(String key, int defaultValue) {
        return getSettings().getInt(key, defaultValue);
    }

    /**
     * 存储float类型数据
     * @param key 键
     * @param value 值
     */
    public static void putFloat(String key, float value) {
        getSettings().edit().putFloat(key, value).commit();
    }

    /**
     * 获取float类型数据
     * @param key 键
     * @param defaultValue 默认值
     * @return 值
     */
    public static float getFloat(String key, float defaultValue) {
        return getSettings().getFloat(key, defaultValue);
    }

    /**
     * 存储long类型数据
     * @param key 键
     * @param value 值
     */
    public static void putLong(String key, long value) {
        getSettings().edit().putLong(key, value).commit();
    }

    /**
     * 获取long类型数据
     * @param key 键
     * @param defaultValue 默认值
     * @return 值
     */
    public static long getLong(String key, long defaultValue) {
        return getSettings().getLong(key, defaultValue);
    }

    /**
     * 存储对象
     * @param key
     * @param object
     */
    public static void putObject(String key, Object object){
        putString(key, new Gson().toJson(object));
    }

    /**
     * 获取对象
     * @param key
     * @param t
     * @param <T>
     * @return
     */
    public static <T> T getObject(String key, T t) {
        String json = getString(key, "");
        if (TextUtils.isEmpty(json)) {
            return t;
        }
        return new Gson().fromJson(json, (Type) t.getClass());
    }

    /**
     * 判断Preference中是否有键
     * @param key 键
     * @return true:有;false:无
     */
    public static boolean hasKey(String key) {
        return getSettings().contains(key);
    }

    /**
     * 清除当前的Preferences数据
     */
    public static void clearPreference() {
        SharedPreferences.Editor editor = getSettings().edit();
        editor.clear();
        editor.commit();
    }

    /**
     * 删除单个
     * @param key
     */
    public static void remove(String key){
        SharedPreferences.Editor editor = getSettings().edit();
        editor.remove(key);
        editor.apply();
    }
}
