package com.hx.lib_common.utils;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/15 9:33
 * Describe:
 */
public class NetworkUtils {

    /**
     * 是否打开wifi
     *
     * @param context
     * @return
     */
    public static boolean isWifiEnabled(Context context) {
        WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        return wifiManager.isWifiEnabled();
    }

    /**
     * 获取wifi的ip
     *
     * @param context
     * @return
     */
    public static String getWifiIp(Context context) {
        //获取wifi服务
        WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        int ipAddress = wifiInfo.getIpAddress();
        if (ipAddress != 0) {
            return intToIp(ipAddress);
        }
        return null;
    }

    /**
     * 获取本地ip
     *
     * @return
     */
    public static String getLocalIp() {
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress()) {
                        String address = inetAddress.getHostAddress();
                        if (address.indexOf(".") > 0) {
                            return address;
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取adb调试端口
     *
     * @return
     */
    public static String getAdbDebugPort() {
        try {
            return (String) new Reflect("android.os.SystemProperties")
                    .invokeMethod("get", "service.adb.tcp.port");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 设置adb调试端口
     *
     * @param port
     * @return
     */
    public static void setAdbDebugPort(int port) {
        ShellUtils.execCommand(new String[]{String.format("setprop service.adb.tcp.port %d", port),
                "stop adbd", "start adbd"
        }, true);
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." +
                ((i >> 8) & 0xFF) + "." +
                ((i >> 16) & 0xFF) + "." +
                (i >> 24 & 0xFF);
    }

}
