package com.hx.lib_common.log;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/5/27 16:59
 * Describe:
 * HLog的配置，只有配置了HLogConfig，HLog才有作用
 */
public class HLogConfig {
    private boolean androidLogEnable = true;
    private boolean fileLogEnable = false;

    private static final class SingletonHolder {
        private static final HLogConfig INSTANCE = new HLogConfig();
    }

    public static HLogConfig getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private HLogConfig() {
    }

    public HLogConfig setAndroidLogEnable(boolean enable) {
        androidLogEnable = enable;
        return this;
    }

    public boolean getAndroidLogEnable() {
        return androidLogEnable;
    }

    public HLogConfig setFileLogEnable(boolean enable) {
        fileLogEnable = enable;
        return this;
    }

    public boolean getFileLogEnable() {
        return fileLogEnable;
    }

    public HLogConfig setIFileLogConfig(IFileLogConfig fileLog){
        if (fileLog != null){
            fileLog.initConfig();
        }
        return this;
    }

}
