package com.hx.lib_common.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.drawable.Drawable;

import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.RawRes;
import androidx.annotation.StringRes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/2 13:51
 * Describe:
 */
public class ResourceUtils {

    public static Drawable getDrawable(@DrawableRes int id) {
        return AppUtils.getApplication().getDrawable(id);
    }

    public static String getString(@StringRes int id) {
        return AppUtils.getApplication().getString(id);
    }

    public static String getString(@StringRes int id, Object... formatArgs) {
        return AppUtils.getApplication().getString(id, formatArgs);
    }

    public static int getColor(@ColorRes int id) {
        return AppUtils.getApplication().getResources().getColor(id);
    }


    /**
     * 拷贝assets文件（目录）到文件
     * @param assetsFilePath
     * @param destFilePath
     * @return
     */
    public static boolean copyFileFromAssets(final String assetsFilePath, final String destFilePath) {
        boolean res = true;
        try {
            AssetManager assets = AppUtils.getApplication().getAssets();
            String[] assetsFiles = assets.list(assetsFilePath);
            if (assetsFiles != null && assetsFiles.length > 0) {
                for (String assetsFile : assetsFiles) {
                    res &= copyFileFromAssets(assetsFilePath + File.separator + assetsFile,
                            destFilePath + File.separator + assetsFile);
                }
            } else {
                res =  FileIoUtils.writeFileFromIS(
                        destFilePath,
                        assets.open(assetsFilePath)
                );
            }
        } catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    /**
     * 获取Asset文件的大小
     * @param context
     * @param assetsFileName: xxx/xxx.avi
     * @return
     */
    public static int getAssetFileLen(Context context, String assetsFileName){
        int length = 0;
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetsFileName);
            length = inputStream.available();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            CloseUtils.closeIO(inputStream);
        }
        return length;
    }


    /**
     * 读Assets文件资源到String
     * @param assetsFilePath
     * @param charsetName
     * @return
     */
    public static String readAssets2String(final String assetsFilePath, final String charsetName) {
        try {
            InputStream is = AppUtils.getApplication().getAssets().open(assetsFilePath);
            StreamUtils.inputStream2String(is, charsetName);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 逐行读assets文件到List
     * @param assetsFilePath
     * @param charsetName
     * @return
     */
    public static List<String> readAssets2List(final String assetsFilePath,
                                               final String charsetName) {
        try {
            InputStream is = AppUtils.getApplication().getAssets().open(assetsFilePath);
            return StreamUtils.inputStream2Lines(is, charsetName);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    /**
     * 将raw目录下的文件拷贝到文件
     * @param resId
     * @param destFilePath
     * @return
     */
    public static boolean copyFileFromRaw(@RawRes final int resId, final String destFilePath) {
        return FileIoUtils.writeFileFromIS(destFilePath,
                AppUtils.getApplication().getResources().openRawResource(resId)
        );
    }

    /**
     * 读raw文件到String
     * @param resId
     * @param charsetName
     * @return
     */
    public static String readRaw2String(@RawRes final int resId, final String charsetName) {
        InputStream inputStream = AppUtils.getApplication().getResources().openRawResource(resId);
        return StreamUtils.inputStream2String(inputStream, charsetName);
    }

    /**
     * 逐行读raw文件到List
     * @param resId
     * @param charsetName
     * @return
     */
    public static List<String> readRaw2List(@RawRes final int resId,
                                            final String charsetName) {
        InputStream inputStream = AppUtils.getApplication().getResources().openRawResource(resId);
        return StreamUtils.inputStream2Lines(inputStream, charsetName);
    }
}
