package com.hx.lib_common.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Copyright © 1997 - 2020 Gosuncn. All Rights Reserved
 * Created by huangxi on 2020/4/2 13:52
 * Describe:
 */
public class AppUtils {

    public static Application getApplication(){
        try {
            return (Application)new Reflect("android.app.ActivityThread")
                    .invokeMethod("currentApplication");
        } catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 获取App版本号
     *
     * @return App版本号
     */
    public static String getAppVersionName() {
        try {
            String packageName = getApplication().getPackageName();
            PackageManager pm = getApplication().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取App版本号
     *
     * @return App版本号
     */
    public static int getAppVersionCode() {
        try {
            String packageName = getApplication().getPackageName();
            PackageManager pm = getApplication().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? 0 : pi.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /**
     * App名称
     * @return
     */
    public static String getAppName(){
        try {
            String packageName = getApplication().getPackageName();
            PackageManager pm = getApplication().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return getApplication().getString(pi.applicationInfo.labelRes);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 获取当前应用包名
     * @return
     */
    public static String getPackageName(){
        return getApplication().getPackageName();
    }


    /**
     * 获取应用的权限
     * @return
     */
    public static List<String> getPermissions() {
        PackageManager pm = getApplication().getPackageManager();
        try {
            String[] permissions = pm.getPackageInfo(getApplication().getPackageName(), PackageManager.GET_PERMISSIONS).requestedPermissions;
            if (permissions == null) return Collections.emptyList();
            return Arrays.asList(permissions);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    /**
     * 获取主进程的进程id
     * @param context
     * @return
     */
    public static int getMainProcessId(Context context) {

        ActivityManager mActivityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.processName.equals(context.getPackageName())) {
                return appProcess.pid;
            }
        }
        return -1;
    }
}
